/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.infos;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.core.publish.PublishedDocumentsFinder;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.platform.publisher.impl.core.SimpleCorePublishedDocument;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;

@Operation(id="Document.GetPublishedDocumentsInfos", category="Document", label="GetPublishedDocumentsInfos", description="Get informations of remote published documents of a given live document.")
public class GetPublishedDocumentsInfos {
    private static final Log log = LogFactory.getLog(GetPublishedDocumentsInfos.class);
    public static final String ID = "Document.GetPublishedDocumentsInfos";
    @Context
    protected CoreSession session;
    @Param(name="readFilter", required=false)
    protected Boolean readFilter;
    public static final String WEBID_PATTERN = "webidpattern";
    public static final String WEB_APP = "/nuxeo/";

    @OperationMethod
    public StringBlob run(DocumentModel document) throws Exception {
        long begin = System.currentTimeMillis();
        JSONArray informations = new JSONArray();
        GetUnrestrictedSections getter = new GetUnrestrictedSections(this.session, PublishedDocumentsFinder.getInstance(), document);
        if (BooleanUtils.isTrue((Boolean)this.readFilter)) {
            getter.run();
        } else {
            getter.runUnrestricted();
        }
        informations = getter.getInformations();
        if (log.isTraceEnabled()) {
            long end = System.currentTimeMillis();
            log.trace((Object)("      [GetPublishedDocumentsInfos]: " + String.valueOf(end - begin) + " ms"));
        }
        return new StringBlob(informations.toString(), "application/json");
    }

    protected static String getDocumentURL(DocumentModel document) {
        String url = "";
        if (document != null && StringUtils.isNotBlank((String)(url = DocumentModelFunctions.documentUrl((DocumentModel)document)))) {
            url = WEB_APP + url;
        }
        return url;
    }

    private static class GetUnrestrictedSections
    extends UnrestrictedSessionRunner {
        private PublishedDocumentsFinder finder;
        private DocumentModel document;
        private JSONArray informations;

        protected GetUnrestrictedSections(CoreSession session, PublishedDocumentsFinder finder, DocumentModel document) {
            super(session);
            this.finder = finder;
            this.document = document;
            this.informations = new JSONArray();
        }

        public JSONArray getInformations() {
            return this.informations;
        }

        public void run() throws ClientException {
            this.informations = this.getSectionsInfos(this.finder, this.session, this.document, this.informations);
        }

        protected JSONArray getSectionsInfos(PublishedDocumentsFinder finder, CoreSession session, DocumentModel document, JSONArray informations) {
            long b = System.currentTimeMillis();
            Map publishedDocumentsIn = finder.find(session, document);
            if (log.isDebugEnabled()) {
                long e = System.currentTimeMillis();
                log.debug((Object)("#getSectionsInfos | publishedDocumentsIn: " + String.valueOf(e - b) + "ms"));
            }
            long b1 = System.currentTimeMillis();
            JSONObject documentInfos = new JSONObject();
            for (Map.Entry entryRef : publishedDocumentsIn.entrySet()) {
                DocumentModel section = ToutaticeDocumentHelper.getUnrestrictedDocument((CoreSession)session, (String)((DocumentRef)entryRef.getKey()).toString());
                documentInfos.element("sectionTitle", (Object)section.getTitle());
                DocumentModel proxy = ((SimpleCorePublishedDocument)entryRef.getValue()).getProxy();
                documentInfos.element("url", (Object)GetPublishedDocumentsInfos.getDocumentURL(proxy));
                documentInfos.element("versionLabel", (Object)proxy.getVersionLabel());
                informations.add((Object)documentInfos);
            }
            if (log.isDebugEnabled()) {
                long e1 = System.currentTimeMillis();
                log.debug((Object)("#getSectionsInfos | buildJson: " + String.valueOf(e1 - b1) + "ms"));
            }
            return informations;
        }
    }
}

