/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.addon.shortname.service;

import fr.toutatice.ecm.acrennes.addon.shortname.service.ShortNameArgDescriptor;
import fr.toutatice.ecm.acrennes.addon.shortname.service.ShortNameMgtService;
import fr.toutatice.ecm.acrennes.addon.shortname.service.ShortNameMgtServiceDescriptor;
import fr.toutatice.ecm.acrennes.addon.shortname.service.ShortNameValidationDescriptor;
import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ShortNameMgtServiceImpl
extends DefaultComponent
implements ShortNameMgtService {
    private static final Log log = LogFactory.getLog(ShortNameMgtServiceImpl.class);
    public static final String EXTENSION_POINTS_POLICIES = "policies";
    protected final Map<String, ShortNameMgtServiceDescriptor> policyDescriptors = new HashMap<String, ShortNameMgtServiceDescriptor>();

    public void deactivate(ComponentContext context) throws Exception {
        if (null != this.policyDescriptors) {
            this.policyDescriptors.clear();
        }
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        ShortNameMgtServiceDescriptor pContribution;
        if (EXTENSION_POINTS_POLICIES.equals(extensionPoint) && (pContribution = (ShortNameMgtServiceDescriptor)contribution).getEnabled().booleanValue()) {
            this.policyDescriptors.put(pContribution.getDoctype(), pContribution);
            log.debug((Object)("Registered the component: " + contributor.getName()));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (EXTENSION_POINTS_POLICIES.equals(extensionPoint)) {
            ShortNameMgtServiceDescriptor pContribution = (ShortNameMgtServiceDescriptor)contribution;
            this.policyDescriptors.remove(pContribution.getDoctype());
            log.debug((Object)("Unregistered the component: " + contributor.getName()));
        }
    }

    @Override
    public ShortNameMgtServiceDescriptor getPolicy(DocumentModel document) {
        return this.policyDescriptors.get(document.getType());
    }

    @Override
    public String getGroupeNamingRule(DocumentModel document, Map<String, String> presetArgs) throws ClientException {
        String namingRule = null;
        ShortNameMgtServiceDescriptor policy = this.policyDescriptors.get(document.getType());
        if (null != policy) {
            ShortNameValidationDescriptor validation = policy.getValidation();
            String pattern = validation.getRolePattern();
            List<ShortNameArgDescriptor> shortNameArgs = validation.getArgs();
            namingRule = this.evaluatePattern(pattern, document, presetArgs, shortNameArgs);
        } else {
            log.warn((Object)("missing policy for document type '" + document.getType() + "' "));
        }
        return namingRule;
    }

    @Override
    public String getIdentifier(DocumentModel document, Map<String, String> presetArgs) throws ClientException {
        String namingRule = null;
        ShortNameMgtServiceDescriptor policy = this.policyDescriptors.get(document.getType());
        if (null != policy) {
            ShortNameValidationDescriptor validation = policy.getValidation();
            String pattern = validation.getIdentifierPattern();
            List<ShortNameArgDescriptor> shortNameArgs = validation.getArgs();
            namingRule = this.evaluatePattern(pattern, document, presetArgs, shortNameArgs);
        } else {
            log.warn((Object)("missing policy for document type '" + document.getType() + "' "));
        }
        return namingRule;
    }

    private String evaluatePattern(String pattern, DocumentModel document, Map<String, String> presetArgs, List<ShortNameArgDescriptor> shortNameArgs) {
        ArrayList<String> args = new ArrayList<String>();
        for (ShortNameArgDescriptor arg : shortNameArgs) {
            if (null != presetArgs && presetArgs.containsKey(arg.getValue())) {
                args.add(presetArgs.get(arg.getValue()));
                continue;
            }
            String value = this.getPropertyValue(document, arg.getValue());
            if (StringUtils.isNotBlank((String)value)) {
                args.add(value);
                continue;
            }
            throw new ClientException("cannot build the shortname naming rule: the document property '" + arg.getValue() + "' is blank");
        }
        return String.format(pattern, args.toArray());
    }

    private String getPropertyValue(DocumentModel document, String xpath) throws ClientException {
        Map properties;
        String value = null;
        value = (String)((Object)document.getPropertyValue(xpath));
        if (StringUtils.isBlank((String)value) && null != (properties = ToutaticeDocumentHelper.getPropertiesParentDoc((CoreSession)document.getCoreSession(), (DocumentModel)document, Arrays.asList(xpath), (Filter)new parentFilter(xpath), (boolean)true, (boolean)true)) && !properties.isEmpty()) {
            value = (String)((Object)((Property)properties.get(xpath)).getValue());
        }
        return value;
    }

    private class parentFilter
    implements Filter {
        private static final long serialVersionUID = 1L;
        private final String xpath;

        public parentFilter(String xpath) {
            this.xpath = xpath;
        }

        public boolean accept(DocumentModel docModel) {
            try {
                return StringUtils.isNotBlank((String)((String)((Object)docModel.getPropertyValue(this.xpath))));
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

