/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.es.customizer.writers.impl;

import fr.toutatice.ecm.es.customizer.writers.api.AbstractCustomJsonESWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.runtime.api.Framework;

public class DefaultCustomJsonESWriter
extends AbstractCustomJsonESWriter {
    private String spaceToIndex = Framework.getProperty((String)"ottc.es.space.indexation", (String)"/default-domain/workspaces");

    @Override
    public boolean accept(DocumentModel doc) {
        return true;
    }

    @Override
    public void writeData(JsonGenerator jg, DocumentModel doc, String[] schemas, Map<String, String> contextParameters) throws IOException {
        this.writeLockInfos(jg, doc);
        if (doc.getPathAsString() != null && doc.getPathAsString().startsWith(this.spaceToIndex)) {
            this.writeSpaceInfos(jg, doc);
        }
    }

    protected void writeLockInfos(JsonGenerator jg, DocumentModel doc) throws JsonGenerationException, IOException {
        Lock lock = doc.getLockInfo();
        if (lock != null) {
            jg.writeStringField("ttc:lockOwner", lock.getOwner());
            jg.writeStringField("ttc:lockCreated", ISODateTimeFormat.dateTime().print((ReadableInstant)new DateTime((Object)lock.getCreated())));
        }
    }

    protected void writeSpaceInfos(JsonGenerator jg, DocumentModel doc) throws JsonGenerationException, IOException {
        List parentDocuments = this.session.getParentDocuments(doc.getRef());
        parentDocuments.add(doc);
        DocumentModel rootSpace = null;
        for (DocumentModel element : parentDocuments) {
            if (!element.hasFacet("Space") || element.getType().equals("Domain")) continue;
            rootSpace = element;
            break;
        }
        if (rootSpace != null) {
            jg.writeStringField("ttc:spaceUuid", rootSpace.getId());
            jg.writeStringField("ttc:spaceTitle", rootSpace.getTitle());
            jg.writeStringField("ttc:spaceType", rootSpace.getType());
            if (rootSpace.hasSchema("webcontainer")) {
                jg.writeStringField("ttc:spaceLdapId", rootSpace.getPropertyValue("webc:url").toString());
            }
        }
    }
}

