/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.invocation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.Context;
import org.apache.directory.server.core.partition.PartitionNexusProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Invocation {
    private final Context caller;
    private final String name;
    private final List<Object> parameters;
    private final Collection<String> bypassed;
    private final PartitionNexusProxy proxy;
    private static final Set<String> EMPTY_STRING_SET = new HashSet<String>();

    public Invocation(PartitionNexusProxy proxy, Context caller, String name) {
        this(proxy, caller, name, null, EMPTY_STRING_SET);
    }

    public Invocation(PartitionNexusProxy proxy, Context caller, String name, Object[] parameters) {
        this(proxy, caller, name, parameters, EMPTY_STRING_SET);
    }

    public Invocation(PartitionNexusProxy proxy, Context caller, String name, Object[] parameters, Collection<String> bypassed) {
        if (proxy == null) {
            throw new NullPointerException("proxy");
        }
        if (caller == null) {
            throw new NullPointerException("caller");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (parameters == null) {
            parameters = new Object[]{};
        }
        this.bypassed = bypassed == null ? EMPTY_STRING_SET : Collections.unmodifiableCollection(bypassed);
        this.proxy = proxy;
        this.caller = caller;
        this.name = name;
        ArrayList<Object> paramList = new ArrayList<Object>();
        for (int i = 0; i < parameters.length; ++i) {
            paramList.add(parameters[i]);
        }
        this.parameters = Collections.unmodifiableList(paramList);
    }

    public PartitionNexusProxy getProxy() {
        return this.proxy;
    }

    public Context getCaller() {
        return this.caller;
    }

    public String getName() {
        return this.name;
    }

    public List<Object> getParameters() {
        return this.parameters;
    }

    public boolean isBypassed(String interceptorName) {
        return this.bypassed.contains(interceptorName);
    }

    public boolean hasBypass() {
        return !this.bypassed.isEmpty();
    }
}

