/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.support;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.definitions.Choice;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDecimalDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyIntegerDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyStringDefinition;
import org.apache.chemistry.opencmis.commons.definitions.RelationshipTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.ContentStreamAllowed;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.impl.CollectionsHelper;

public final class TypeValidator {
    private TypeValidator() {
    }

    public static void validateRequiredSystemProperties(Properties properties) {
        if (properties == null || properties.getProperties() == null) {
            throw new CmisInvalidArgumentException("Cannot create object, no properties are given");
        }
        if (!properties.getProperties().containsKey("cmis:objectTypeId")) {
            throw new CmisInvalidArgumentException("Cannot create object, type id is missing");
        }
    }

    private static boolean isMandatorySystemProperty(String propertyId) {
        return propertyId.equals("cmis:objectTypeId");
    }

    static <T> PropertyValidator<T> createPropertyValidator(PropertyDefinition<?> propDef) {
        PropertyValidator result = null;
        result = propDef instanceof PropertyIntegerDefinition ? new PropertyValidatorInteger() : (propDef instanceof PropertyDecimalDefinition ? new PropertyValidatorDecimal() : (propDef instanceof PropertyStringDefinition ? new PropertyValidatorString() : new PropertyValidator()));
        return result;
    }

    public static <T> void validateProperties(TypeDefinition typeDef, Properties properties, boolean checkMandatory) {
        TypeValidator.validateProperties(typeDef, properties, checkMandatory, false);
    }

    public static <T> void validateProperties(TypeDefinition typeDef, Properties properties, boolean checkMandatory, boolean cmis11) {
        List<String> propDefsRequired = TypeValidator.getMandatoryPropDefs(typeDef.getPropertyDefinitions());
        if (properties != null) {
            for (PropertyData prop : properties.getProperties().values()) {
                String propertyId = prop.getId();
                if (null == propertyId) {
                    throw new CmisInvalidArgumentException("Property id cannot be null");
                }
                BaseTypeId baseTypeId = typeDef.getBaseTypeId();
                if (checkMandatory && propDefsRequired.contains(propertyId)) {
                    propDefsRequired.remove(propertyId);
                }
                if (TypeValidator.isSystemProperty(baseTypeId, propertyId, cmis11)) continue;
                if (TypeValidator.typeContainsProperty(typeDef, propertyId)) {
                    PropertyDefinition<T> propDef = TypeValidator.getPropertyDefinition(typeDef, propertyId);
                    PropertyValidator<T> validator = TypeValidator.createPropertyValidator(propDef);
                    validator.validate(propDef, prop);
                    continue;
                }
                throw new CmisConstraintException("Unknown property " + propertyId + " in type " + typeDef.getId());
            }
        }
        if (checkMandatory && !propDefsRequired.isEmpty()) {
            throw new CmisConstraintException("The following mandatory properties are missing: " + propDefsRequired);
        }
    }

    public static <T> void validateProperties(List<TypeDefinition> typeDefs, Properties properties, boolean checkMandatory) {
        if (properties == null) {
            return;
        }
        HashMap<String, Boolean> checkedProperties = new HashMap<String, Boolean>();
        for (String propId : properties.getProperties().keySet()) {
            checkedProperties.put(propId, false);
        }
        for (TypeDefinition typeDef : typeDefs) {
            List<String> propDefsRequired = TypeValidator.getMandatoryPropDefs(typeDef.getPropertyDefinitions());
            for (PropertyData prop : properties.getProperties().values()) {
                String propertyId = prop.getId();
                if (null == propertyId) {
                    throw new CmisInvalidArgumentException("Property id cannot be null");
                }
                BaseTypeId baseTypeId = typeDef.getBaseTypeId();
                if (checkMandatory && propDefsRequired.contains(propertyId)) {
                    propDefsRequired.remove(propertyId);
                }
                if (TypeValidator.isSystemProperty(baseTypeId, propertyId, true)) {
                    checkedProperties.put(prop.getId(), true);
                    continue;
                }
                if (!TypeValidator.typeContainsProperty(typeDef, propertyId)) continue;
                checkedProperties.put(prop.getId(), true);
                PropertyDefinition<T> propDef = TypeValidator.getPropertyDefinition(typeDef, propertyId);
                PropertyValidator<T> validator = TypeValidator.createPropertyValidator(propDef);
                validator.validate(propDef, prop);
            }
            if (!checkMandatory || propDefsRequired.isEmpty()) continue;
            throw new CmisConstraintException("The following mandatory properties are missing: " + propDefsRequired);
        }
        ArrayList<String> unknownProperties = new ArrayList<String>();
        for (String propId : properties.getProperties().keySet()) {
            if (((Boolean)checkedProperties.get(propId)).booleanValue()) continue;
            unknownProperties.add(propId);
        }
        if (!unknownProperties.isEmpty()) {
            throw new CmisConstraintException("The following properties are not known in any of the types of this object: " + unknownProperties);
        }
    }

    public static void validateVersionStateForCreate(DocumentTypeDefinition typeDef, VersioningState verState) {
        if (null == verState) {
            return;
        }
        if (typeDef.isVersionable().booleanValue() && verState.equals((Object)VersioningState.NONE) || !typeDef.isVersionable().booleanValue() && !verState.equals((Object)VersioningState.NONE)) {
            throw new CmisConstraintException("The versioning state flag is imcompatible to the type definition.");
        }
    }

    public static void validateAllowedChildObjectTypes(TypeDefinition childTypeDef, List<String> allowedChildTypes) {
        TypeValidator.validateAllowedTypes(childTypeDef, allowedChildTypes, "in this folder");
    }

    public static void validateAllowedRelationshipTypes(RelationshipTypeDefinition relationshipTypeDef, TypeDefinition sourceTypeDef, TypeDefinition targetTypeDef) {
        List allowedSourceTypes = relationshipTypeDef.getAllowedSourceTypeIds();
        TypeValidator.validateAllowedTypes(sourceTypeDef, allowedSourceTypes, " as source type in this relationship");
        List allowedTargetTypes = relationshipTypeDef.getAllowedTargetTypeIds();
        TypeValidator.validateAllowedTypes(targetTypeDef, allowedTargetTypes, " as target type in this relationship");
    }

    protected static void validateAllowedTypes(TypeDefinition typeDef, List<String> allowedTypes, String description) {
        if (CollectionsHelper.isNullOrEmpty(allowedTypes)) {
            return;
        }
        for (String allowedType : allowedTypes) {
            if (!allowedType.equals(typeDef.getId())) continue;
            return;
        }
        throw new CmisConstraintException("The requested type " + typeDef.getId() + " is not allowed " + description);
    }

    public static void validateAcl(TypeDefinition typeDef, Acl addACEs, Acl removeACEs) {
        if (!(typeDef.isControllableAcl().booleanValue() || addACEs == null && removeACEs == null)) {
            throw new CmisConstraintException("acl set for type: " + typeDef.getDisplayName() + " that is not controllableACL");
        }
    }

    public static void validateContentAllowed(DocumentTypeDefinition typeDef, boolean hasContent) {
        ContentStreamAllowed contentAllowed = typeDef.getContentStreamAllowed();
        if (ContentStreamAllowed.REQUIRED == contentAllowed && !hasContent) {
            throw new CmisConstraintException("Type " + typeDef.getId() + " requires content but document has no content.");
        }
        if (ContentStreamAllowed.NOTALLOWED == contentAllowed && hasContent) {
            throw new CmisConstraintException("Type " + typeDef.getId() + " does not allow content but document has content.");
        }
    }

    private static List<String> getMandatoryPropDefs(Map<String, PropertyDefinition<?>> propDefs) {
        ArrayList<String> res = new ArrayList<String>();
        if (null != propDefs) {
            for (PropertyDefinition<?> propDef : propDefs.values()) {
                if (!propDef.isRequired().booleanValue() || TypeValidator.isMandatorySystemProperty(propDef.getId())) continue;
                res.add(propDef.getId());
            }
        }
        return res;
    }

    public static boolean typeContainsProperty(TypeDefinition typeDef, String propertyId) {
        Map propDefs = typeDef.getPropertyDefinitions();
        if (null == propDefs) {
            return false;
        }
        PropertyDefinition propDef = (PropertyDefinition)propDefs.get(propertyId);
        return propDef != null;
    }

    public static boolean typeContainsPropertyWithQueryName(TypeDefinition typeDef, String propertyQueryName) {
        Map propDefs = typeDef.getPropertyDefinitions();
        if (null == propDefs) {
            return false;
        }
        for (PropertyDefinition propDef : propDefs.values()) {
            if (!propDef.getQueryName().equalsIgnoreCase(propertyQueryName)) continue;
            return true;
        }
        return false;
    }

    private static <T> PropertyDefinition<T> getPropertyDefinition(TypeDefinition typeDef, String propertyId) {
        Map propDefs = typeDef.getPropertyDefinitions();
        if (null == propDefs) {
            return null;
        }
        PropertyDefinition propDef = (PropertyDefinition)propDefs.get(propertyId);
        if (null == propDef) {
            return null;
        }
        return propDef;
    }

    private static boolean isSystemProperty(BaseTypeId baseTypeId, String propertyId, boolean cmis11) {
        if (propertyId.equals("cmis:name")) {
            return true;
        }
        if (propertyId.equals("cmis:objectId")) {
            return true;
        }
        if (propertyId.equals("cmis:objectTypeId")) {
            return true;
        }
        if (propertyId.equals("cmis:baseTypeId")) {
            return true;
        }
        if (propertyId.equals("cmis:createdBy")) {
            return true;
        }
        if (propertyId.equals("cmis:creationDate")) {
            return true;
        }
        if (propertyId.equals("cmis:lastModifiedBy")) {
            return true;
        }
        if (propertyId.equals("cmis:lastModificationDate")) {
            return true;
        }
        if (propertyId.equals("cmis:changeToken")) {
            return true;
        }
        if (cmis11 && propertyId.equals("cmis:description")) {
            return true;
        }
        if (cmis11 && propertyId.equals("cmis:secondaryObjectTypeIds")) {
            return true;
        }
        if (baseTypeId.equals((Object)BaseTypeId.CMIS_DOCUMENT)) {
            if (propertyId.equals("cmis:isImmutable")) {
                return true;
            }
            if (propertyId.equals("cmis:isLatestVersion")) {
                return true;
            }
            if (propertyId.equals("cmis:isMajorVersion")) {
                return true;
            }
            if (propertyId.equals("cmis:versionSeriesId")) {
                return true;
            }
            if (propertyId.equals("cmis:isLatestMajorVersion")) {
                return true;
            }
            if (propertyId.equals("cmis:versionLabel")) {
                return true;
            }
            if (propertyId.equals("cmis:versionSeriesId")) {
                return true;
            }
            if (propertyId.equals("cmis:isVersionSeriesCheckedOut")) {
                return true;
            }
            if (propertyId.equals("cmis:versionSeriesCheckedOutBy")) {
                return true;
            }
            if (propertyId.equals("cmis:versionSeriesCheckedOutId")) {
                return true;
            }
            if (propertyId.equals("cmis:checkinComment")) {
                return true;
            }
            if (propertyId.equals("cmis:contentStreamLength")) {
                return true;
            }
            if (propertyId.equals("cmis:contentStreamMimeType")) {
                return true;
            }
            if (propertyId.equals("cmis:contentStreamFileName")) {
                return true;
            }
            return propertyId.equals("cmis:contentStreamId");
        }
        if (baseTypeId.equals((Object)BaseTypeId.CMIS_FOLDER)) {
            if (propertyId.equals("cmis:parentId")) {
                return true;
            }
            if (propertyId.equals("cmis:allowedChildObjectTypeIds")) {
                return true;
            }
            return propertyId.equals("cmis:path");
        }
        if (baseTypeId.equals((Object)BaseTypeId.CMIS_POLICY)) {
            if (propertyId.equals("cmis:sourceId")) {
                return true;
            }
            return propertyId.equals("cmis:targetId");
        }
        return propertyId.equals("cmis:policyText");
    }

    static class PropertyValidatorString
    extends PropertyValidator<String> {
        PropertyValidatorString() {
        }

        @Override
        public void validate(PropertyDefinition<String> propDef, PropertyData<String> property) {
            long len;
            super.validate(propDef, property);
            long maxLen = ((PropertyStringDefinition)propDef).getMaxLength() == null ? -1L : ((PropertyStringDefinition)propDef).getMaxLength().longValue();
            long l = len = property.getFirstValue() == null ? -1L : (long)((String)property.getFirstValue()).length();
            if (maxLen >= 0L && len >= 0L && maxLen < len) {
                throw new CmisConstraintException("For property with id " + propDef.getId() + " the length of " + len + "is bigger than the maximum allowed length  " + maxLen);
            }
        }
    }

    static class PropertyValidatorDecimal
    extends PropertyValidator<BigDecimal> {
        PropertyValidatorDecimal() {
        }

        @Override
        public void validate(PropertyDefinition<BigDecimal> propDef, PropertyData<BigDecimal> property) {
            super.validate(propDef, property);
            BigDecimal propVal = (BigDecimal)property.getFirstValue();
            BigDecimal minVal = ((PropertyDecimalDefinition)propDef).getMinValue();
            BigDecimal maxVal = ((PropertyDecimalDefinition)propDef).getMaxValue();
            if (minVal != null && propVal != null && propVal.compareTo(minVal) == -1) {
                throw new CmisConstraintException("For property with id " + propDef.getId() + " the value " + propVal + " is less than the minimum value " + minVal);
            }
            if (maxVal != null && propVal != null && propVal.compareTo(maxVal) == 1) {
                throw new CmisConstraintException("For property with id " + propDef.getId() + " the value " + propVal + " is bigger than the maximum value " + maxVal);
            }
        }
    }

    static class PropertyValidatorInteger
    extends PropertyValidator<BigInteger> {
        PropertyValidatorInteger() {
        }

        @Override
        public void validate(PropertyDefinition<BigInteger> propDef, PropertyData<BigInteger> property) {
            super.validate(propDef, property);
            BigInteger propVal = (BigInteger)property.getFirstValue();
            BigInteger minVal = ((PropertyIntegerDefinition)propDef).getMinValue();
            BigInteger maxVal = ((PropertyIntegerDefinition)propDef).getMaxValue();
            if (minVal != null && propVal != null && propVal.compareTo(minVal) == -1) {
                throw new CmisConstraintException("For property with id " + propDef.getId() + " the value " + propVal + " is less than the minimum value " + minVal);
            }
            if (maxVal != null && propVal != null && propVal.compareTo(maxVal) == 1) {
                throw new CmisConstraintException("For property with id " + propDef.getId() + " the value " + propVal + " is bigger than the maximum value " + maxVal);
            }
        }
    }

    static class PropertyValidator<T> {
        PropertyValidator() {
        }

        public void validate(PropertyDefinition<T> propDef, PropertyData<T> prop) {
            if (propDef.getCardinality() == Cardinality.SINGLE && prop.getValues() != null && prop.getValues().size() > 1) {
                throw new CmisConstraintException("The property with id " + propDef.getId() + " is single valued, but multiple values are passed " + prop.getValues());
            }
            if (CollectionsHelper.isNotEmpty((Collection)propDef.getChoices())) {
                this.validateChoices(propDef, prop);
            }
        }

        private void validateChoices(PropertyDefinition<T> propDef, PropertyData<T> prop) {
            boolean isAllowedValue = true;
            boolean hasMultiValueChoiceLists = false;
            for (Choice allowedValue : propDef.getChoices()) {
                if (allowedValue.getValue() == null || allowedValue.getValue().size() <= 1) continue;
                hasMultiValueChoiceLists = true;
            }
            if (hasMultiValueChoiceLists) {
                isAllowedValue = false;
                List actualValues = prop.getValues();
                for (Choice allowedValue : propDef.getChoices()) {
                    if (allowedValue.getValue().size() == actualValues.size()) {
                        boolean listValuesAreEqual = true;
                        Iterator it = allowedValue.getValue().iterator();
                        for (Object actualValue : actualValues) {
                            if (actualValue.equals(it.next())) continue;
                            listValuesAreEqual = false;
                            break;
                        }
                        if (listValuesAreEqual) {
                            isAllowedValue = true;
                        }
                    }
                    if (!isAllowedValue) continue;
                    break;
                }
            } else {
                List<T> allowedValues = this.getAllowedValues(propDef.getChoices());
                for (Object actualValue : prop.getValues()) {
                    if (allowedValues.contains(actualValue)) continue;
                    isAllowedValue = false;
                    break;
                }
            }
            if (!isAllowedValue) {
                throw new CmisConstraintException("The property with id " + propDef.getId() + " has a fixed set of values. Value(s) " + prop.getValues() + " are not listed.");
            }
        }

        private List<T> getAllowedValues(List<Choice<T>> choices) {
            ArrayList<Object> allowedValues = new ArrayList<Object>(choices.size());
            for (Choice<T> choice : choices) {
                if (CollectionsHelper.isNotEmpty((Collection)choice.getValue())) {
                    allowedValues.add(choice.getValue().get(0));
                }
                if (!CollectionsHelper.isNotEmpty((Collection)choice.getChoice())) continue;
                List x = choice.getChoice();
                allowedValues.addAll(this.getAllowedValues(x));
            }
            return allowedValues;
        }
    }
}

