/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.automation;

import fr.toutatice.ecm.acrennes.core.services.UserworkspaceCreationWork;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchResult;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.ldap.LDAPDirectory;
import org.nuxeo.ecm.directory.ldap.LDAPSession;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Services.AskUserworkspaceCreation", category="Services", label="Ask for a userworkspace creation", description="Ask for a userworkspace creation, return a work state .")
public class AskUserworkspaceCreation {
    public static final String ID = "Services.AskUserworkspaceCreation";
    private static final Log uwLog = LogFactory.getLog((String)"fr.toutatice.userworkspaces");
    @Context
    protected CoreSession session;
    @Param(name="username", required=true)
    protected String username;
    @Param(name="doCreate", required=true)
    protected Boolean doCreate;
    private List<String> deniedProfiles;

    @OperationMethod
    public Blob run() throws Exception {
        JSONObject ret = new JSONObject();
        WorkManager workManager = (WorkManager)Framework.getLocalService(WorkManager.class);
        UserworkspaceCreationWork work = new UserworkspaceCreationWork(this.username);
        Work.State workState = workManager.getWorkState(work.getId());
        if (!this.userMayHaveWorkspace(this.username)) {
            ret.put((Object)"workState", (Object)"NOT_AVAILABLE");
            return new StringBlob(ret.toString(), "application/json");
        }
        if (this.doCreate.booleanValue() && (workState == null || workState == Work.State.UNKNOWN)) {
            workManager.schedule((Work)work);
            workState = Work.State.SCHEDULED;
            uwLog.info((Object)("AskUserworkspaceCreation / Planficiation pour " + this.username + "/ taille file d'attente :" + workManager.getQueueSize("userworkspaces-creation-queue", null)));
        } else {
            if (workState == null) {
                workState = Work.State.UNKNOWN;
            }
            uwLog.info((Object)("AskUserworkspaceCreation / Etat job " + this.username + " " + workState));
        }
        ret.put((Object)"workState", (Object)workState.name());
        return new StringBlob(ret.toString(), "application/json");
    }

    private boolean userMayHaveWorkspace(String userName) {
        List<String> deniedProfiles = this.getDeniedProfiles();
        if (deniedProfiles.size() == 0) {
            return true;
        }
        DirectoryService directoryService = (DirectoryService)Framework.getLocalService(DirectoryService.class);
        LDAPDirectory userDir = (LDAPDirectory)directoryService.getDirectory("userLdapDirectory");
        LDAPSession session = (LDAPSession)userDir.getSession();
        DirContext context = session.getContext();
        String searchBaseDn = userDir.getConfig().getSearchBaseDn();
        try {
            NamingEnumeration<SearchResult> search = context.search(searchBaseDn, "(uid=" + userName + ")", userDir.getSearchControls());
            SearchResult next = search.next();
            Attribute profilesAttr = next.getAttributes().get("entpersonprofils");
            if (profilesAttr != null) {
                for (int i = 0; i < profilesAttr.size(); ++i) {
                    String memberOf = profilesAttr.get(i).toString();
                    if (!deniedProfiles.contains(memberOf)) continue;
                    return false;
                }
            }
        }
        catch (NamingException e) {
            uwLog.error((Object)("Impossible de v\u00e9rifier les groupes de " + userName));
        }
        return true;
    }

    private List<String> getDeniedProfiles() {
        if (this.deniedProfiles == null) {
            this.deniedProfiles = new ArrayList<String>();
            String deniedProfilesProp = Framework.getProperty((String)"fr.toutatice.userworkspaces.denied_profiles");
            if (StringUtils.isNotBlank((String)deniedProfilesProp)) {
                String[] split;
                for (String spl : split = deniedProfilesProp.split(";")) {
                    this.deniedProfiles.add(spl.trim());
                    uwLog.info((Object)("Filtrage actif pour le profil " + spl));
                }
            }
        }
        return this.deniedProfiles;
    }
}

