/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.automation;

import fr.toutatice.ecm.acrennes.automation.freemarker.AcarennesExportFunctions;
import fr.toutatice.ecm.platform.core.helper.ToutaticeSilentProcessRunnerHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.rendering.FreemarkerRender;
import org.nuxeo.ecm.automation.core.scripting.Functions;
import org.nuxeo.ecm.automation.core.scripting.Scripting;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;

@Operation(id="Services.ExportTree", category="Services", label="Custom tree export", description="Genere un fichier d'export XML d'une arborescence")
public class ExportTree {
    public static final String ID = "Services.ExportTree";
    private static final Log log = LogFactory.getLog(ExportTree.class);
    @Context
    protected OperationContext ctx;
    @Param(name="template", widget="TemplateResource")
    protected String template;
    @Param(name="file name", required=false, values={"export.xml"})
    protected String name = "export.xml";
    @Param(name="mime type", required=false, values={"text/xml"})
    protected String mimetype = "text/xml";

    @OperationMethod
    public Blob run(DocumentModel doc) throws Exception {
        AcarenExportRunner runner = new AcarenExportRunner(this.ctx, doc);
        runner.runUnrestricted();
        return runner.getBlob();
    }

    private Map<String, Object> buildObjectsStructure(CoreSession session, DocumentModel document) {
        return Scripting.initBindings((OperationContext)this.ctx);
    }

    private class AcarenExportRunner
    extends ToutaticeSilentProcessRunnerHelper {
        private DocumentModel root;
        private Blob blob;

        public AcarenExportRunner(OperationContext ctx, DocumentModel root) {
            super(ctx.getCoreSession());
            this.root = root;
            this.blob = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws ClientException {
            FreemarkerRender ftl = new FreemarkerRender();
            Object currentFninstance = null;
            AcarennesExportFunctions localFn = null;
            try {
                currentFninstance = Functions.getInstance();
                localFn = new AcarennesExportFunctions();
                Functions.setInstance((Object)((Object)localFn));
                Map map = ExportTree.this.buildObjectsStructure(this.session, this.root);
                File tempFile = File.createTempFile("Export-", ".tmp");
                FileWriter writer = new FileWriter(tempFile);
                ftl.render(ExportTree.this.template, (Object)map, (Writer)writer);
                writer.flush();
                this.blob = new FileBlob((InputStream)new FileInputStream(tempFile), ExportTree.this.mimetype);
                this.blob.setFilename(ExportTree.this.name);
                tempFile.delete();
            }
            catch (Exception e) {
                log.error((Object)("Failed to render the template '" + ExportTree.this.template + "', error: " + e.getMessage()));
            }
            finally {
                Functions.setInstance((Object)currentFninstance);
            }
        }

        public Blob getBlob() {
            return this.blob;
        }
    }
}

