/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.automation;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;

@Operation(id="Document.Unpublish", category="Document", label="Unpublish Document", description="Unpublish the input document into the target section. Existing proxy(ies) is(are) removed. Return the input document.")
public class UnpublishDocument {
    public static final String ID = "Document.Unpublish";
    @Context
    protected CoreSession session;
    @Param(name="target", required=true)
    protected DocumentModel target;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) throws Exception {
        DocumentRef targetRef = this.target.getRef();
        if (null != targetRef) {
            DocumentModelList proxies = this.session.getProxies(doc.getRef(), targetRef);
            for (DocumentModel proxy : proxies) {
                this.session.removeDocument(proxy.getRef());
            }
        }
        return doc;
    }
}

