/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.jdbcx;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.javasimon.jdbc.SimonConnection;
import org.javasimon.jdbcx.AbstractSimonDataSource;

public final class SimonDataSource
extends AbstractSimonDataSource
implements DataSource {
    private DataSource ds;

    private DataSource datasource() throws SQLException {
        if (this.ds == null) {
            Object o;
            if (this.realDataSourceClassName == null || this.realDataSourceClassName.length() == 0) {
                throw new SQLException("Property realdatasourceclassname is not set");
            }
            try {
                o = Class.forName(this.realDataSourceClassName).newInstance();
            }
            catch (Exception e) {
                throw new SQLException(e.getMessage());
            }
            if (o instanceof DataSource) {
                this.ds = (DataSource)o;
                try {
                    for (Method m : this.ds.getClass().getMethods()) {
                        String methodName = m.getName();
                        if (methodName.equalsIgnoreCase("setUser")) {
                            m.invoke((Object)this.ds, this.user);
                            continue;
                        }
                        if (methodName.equalsIgnoreCase("setPassword")) {
                            m.invoke((Object)this.ds, this.password);
                            continue;
                        }
                        if (!methodName.equalsIgnoreCase("setUrl")) continue;
                        m.invoke((Object)this.ds, this.url);
                    }
                }
                catch (Exception e) {
                    throw new SQLException(e.getMessage());
                }
                this.ds.setLogWriter(this.logWriter);
                this.ds.setLoginTimeout(this.loginTimeout);
            } else {
                throw new SQLException("Class in realdatasourceclassname is not a DataSource");
            }
        }
        return this.ds;
    }

    public Connection getConnection() throws SQLException {
        return new SimonConnection(this.datasource().getConnection(), this.prefix);
    }

    public Connection getConnection(String user, String password) throws SQLException {
        return new SimonConnection(this.datasource().getConnection(user, password), this.prefix);
    }
}

