/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeSilentProcessRunnerHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.versioning.VersioningService;

@Operation(id="Document.SetSpaceID", category="Document", label="Set spaceId.", description="Update spaceID's value of a document and his children.")
public class SetSpaceID {
    public static final String ID = "Document.SetSpaceID";
    public final String WORKSPACE_TYPE = "Workspace";
    public final String USER_WORKSPACE_TYPE = "UserWorkspace";
    private static final List<Class<?>> FILTERED_SERVICES_LIST = new ArrayList<Class<?>>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(EventService.class);
            this.add(VersioningService.class);
        }
    };
    @Context
    protected CoreSession coreSession;

    @OperationMethod
    public DocumentModel run(DocumentModel doc) throws Exception {
        InnerSilentModeUpdateSpaceID runner = new InnerSilentModeUpdateSpaceID(this.coreSession, doc);
        runner.silentRun(true, FILTERED_SERVICES_LIST);
        return runner.getDoc();
    }

    private class InnerSilentModeUpdateSpaceID
    extends ToutaticeSilentProcessRunnerHelper {
        DocumentModel doc;

        public InnerSilentModeUpdateSpaceID(CoreSession session, DocumentModel doc) {
            super(session);
            this.doc = doc;
        }

        public void run() throws ClientException {
            String spaceID = ToutaticeDocumentHelper.getSpaceID((CoreSession)this.session, (DocumentModel)this.doc, (boolean)true);
            this.updateDoc(this.doc, spaceID);
        }

        public DocumentModel getDoc() throws ClientException {
            return this.doc;
        }

        private void updateDoc(DocumentModel doc, String spaceID) throws ClientException, PropertyException {
            if (!doc.isImmutable() && doc.hasSchema("toutatice")) {
                doc.setPropertyValue("ttc:spaceID", (Serializable)((Object)spaceID));
                this.session.saveDocument(doc);
            }
            if (doc.isFolder()) {
                StringBuilder query = new StringBuilder();
                query.append("select * from Document where ecm:mixinType != 'HiddenInNavigation' AND ecm:isCheckedInVersion = 0 AND ");
                query.append("ecm:currentLifeCycleState != 'deleted' AND ecm:isProxy = 0 AND ecm:parentId = '");
                query.append(doc.getId());
                query.append("'");
                DocumentModelList children = this.session.query(query.toString());
                if (children != null && !children.isEmpty()) {
                    String childSpaceID = ToutaticeDocumentHelper.getSpaceID((CoreSession)this.session, (DocumentModel)((DocumentModel)children.get(0)), (boolean)true);
                    for (DocumentModel child : children) {
                        this.updateDoc(child, childSpaceID);
                    }
                }
            }
        }
    }
}

