/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.web.context;

import fr.toutatice.ecm.platform.core.query.helper.ToutaticeEsQueryHelper;
import fr.toutatice.ecm.platform.web.context.ToutaticeNavigationContextBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;

@Name(value="navigationContext")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=56)
public class AcrennesNavigationContextBean
extends ToutaticeNavigationContextBean {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AcrennesNavigationContextBean.class);
    private static final String DOMAINS_QUERY = "SELECT * FROM document WHERE ecm:primaryType='Domain' AND ecm:mixinType != 'HiddenInNavigation' AND ecm:isVersion = 0 AND ecm:currentLifeCycleState <> 'deleted' AND ecm:isProxy = 0 ORDER BY dc:title";

    @Factory(value="menuAvailableDomains", scope=ScopeType.SESSION)
    public DocumentModelList getMenuDocuments() throws ClientException {
        String logPrefix = "<toutaticeResetCurrentPath> ";
        if (null == this.documentManager) {
            log.error((Object)"<toutaticeResetCurrentPath> documentManager not initialized");
            return new DocumentModelListImpl();
        }
        long begin = System.currentTimeMillis();
        DocumentModelList domains = ToutaticeEsQueryHelper.query((CoreSession)this.documentManager, (String)DOMAINS_QUERY);
        if (log.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            log.debug((Object)("[Domains query]: " + String.valueOf(end - begin) + " ms"));
        }
        return domains;
    }

    public String getMetadataDomain() throws ClientException {
        DocumentModel domain = this.getCurrentDomain();
        if (domain == null) {
            return "none";
        }
        return (String)domain.getProperty("acaren", "commutateur");
    }

    @Factory(value="isShowingAcarenPersonalWorkspace", scope=ScopeType.SESSION)
    public boolean isShowingAcarenPersonalWorkspace() {
        DocumentModel currentDoc = this.getCurrentDocument();
        if (currentDoc == null || currentDoc.getPath().segmentCount() < 2) {
            return false;
        }
        String domain = currentDoc.getPath().segment(0);
        boolean showingPersonalWorkspace = domain.equalsIgnoreCase("home") || domain.equalsIgnoreCase("userworkspace-domain");
        return showingPersonalWorkspace;
    }
}

