/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.web.filemanager;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.remoting.WebRemote;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.webapp.filemanager.FileManageActionsBean;

@Name(value="FileManageActions")
@Scope(value=ScopeType.EVENT)
@Install(precedence=56)
public class AcrennesFileManageActionsBean
extends FileManageActionsBean {
    @WebRemote
    public String moveWithId(String docId, String containerId) throws ClientException {
        return super.moveWithId(docId, containerId);
    }

    @WebRemote
    protected String checkMoveAllowed(DocumentRef docRef, DocumentRef containerRef) throws ClientException {
        DocumentModel doc = this.documentManager.getDocument(docRef);
        DocumentModel container = this.documentManager.getDocument(containerRef);
        if ((container.getPathAsString() + "/").startsWith(doc.getPathAsString() + "/")) {
            this.facesMessages.add(StatusMessage.Severity.WARN, (String)this.messages.get("move_impossible"), new Object[0]);
            return "MOVE_IMPOSSIBLE";
        }
        if (!this.documentManager.hasPermission(doc.getParentRef(), "RemoveChildren") || !this.documentManager.hasPermission(doc.getRef(), "Remove")) {
            this.facesMessages.add(StatusMessage.Severity.WARN, (String)this.messages.get("move_impossible"), new Object[0]);
            return "MOVE_IMPOSSIBLE";
        }
        if (!this.documentManager.hasPermission(containerRef, "AddChildren")) {
            this.facesMessages.add(StatusMessage.Severity.WARN, (String)this.messages.get("move_insuffisant_rights"), new Object[0]);
            return "MOVE_IMPOSSIBLE";
        }
        if (doc.isProxy()) {
            if (!container.hasFacet("PublishSpace")) {
                this.facesMessages.add(StatusMessage.Severity.WARN, (String)this.messages.get("move_impossible"), new Object[0]);
                return "MOVE_IMPOSSIBLE";
            }
        } else if (!this.typeManager.isAllowedSubType(doc.getType(), container.getType(), container)) {
            this.facesMessages.add(StatusMessage.Severity.WARN, (String)this.messages.get("move_impossible"), new Object[0]);
            return "MOVE_IMPOSSIBLE";
        }
        return "MOVE_OK";
    }
}

