/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.collab.tools.mail;

import fr.toutatice.ecm.platform.web.fragments.PageBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.ui.web.util.SeamComponentCallHelper;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.webapp.notification.email.EmailNotificationSenderActionsBean;
import org.nuxeo.ecm.webapp.security.PrincipalListManager;
import org.nuxeo.runtime.api.Framework;

@Name(value="emailNotifSenderAction")
@Scope(value=ScopeType.EVENT)
@Install(precedence=31)
public class ToutaticeEmailNotificationSenderActionsBean
extends EmailNotificationSenderActionsBean {
    @In(create=true)
    PageBean pageBean;
    @In(create=true)
    transient UserManager userManager;
    protected List<String> savedRecipients;
    private Integer totalUserCount;
    private static final long serialVersionUID = -5722586829804268237L;
    protected transient PrincipalListManager principalManager = (PrincipalListManager)SeamComponentCallHelper.getSeamComponentByName((String)"principalListManager");

    public Map<String, Integer> getDisplayedGroups() {
        HashMap<String, Integer> displayedGroups = new HashMap<String, Integer>();
        List<String> recipients = this.getRecipients();
        for (String recipient : recipients) {
            NuxeoGroup group = this.userManager.getGroup(recipient);
            if (group == null) continue;
            List memberUsers = group.getMemberUsers();
            int nbMembers = memberUsers != null ? memberUsers.size() : 0;
            displayedGroups.put(group.getLabel(), nbMembers);
        }
        return displayedGroups;
    }

    public ArrayList<String> getDisplayedRecipients() {
        ArrayList<String> displayedRecipients = new ArrayList<String>();
        List<String> recipients = this.getRecipients();
        for (String recipient : recipients) {
            NuxeoPrincipal principal = this.userManager.getPrincipal(recipient);
            if (principal == null) continue;
            displayedRecipients.add(principal.getFirstName() + " " + principal.getLastName());
        }
        return displayedRecipients;
    }

    public List<String> getRecipients() {
        if (this.savedRecipients == null) {
            this.savedRecipients = new ArrayList<String>();
            if (!this.isInCollabWorkspaceContext()) {
                List selectedUsers;
                List defaultRecipients = super.getRecipients();
                if (CollectionUtils.isNotEmpty((Collection)defaultRecipients)) {
                    this.savedRecipients.addAll(defaultRecipients);
                }
                if (CollectionUtils.isNotEmpty((Collection)(selectedUsers = this.principalManager.getSelectedUsers()))) {
                    this.savedRecipients.addAll(selectedUsers);
                }
            }
            super.setRecipients(this.savedRecipients);
        }
        return this.savedRecipients;
    }

    public boolean isInCollabWorkspaceContext() {
        String collabWorkspacePath = Framework.getProperty((String)"ottc.collab.workspacepath", (String)"/default-domain/workspaces");
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        boolean inworkspacepath = false;
        if (currentDocument != null) {
            inworkspacepath = currentDocument.getPathAsString().startsWith(collabWorkspacePath);
        }
        return inworkspacepath;
    }

    public void setRecipients(List<String> recipients) {
        this.savedRecipients = recipients;
        super.setRecipients(this.savedRecipients);
    }

    public Integer totalUserCount(List<String> recipients) {
        HashSet<String> all = new HashSet<String>();
        for (String recipient : this.savedRecipients) {
            NuxeoPrincipal principal = this.userManager.getPrincipal(recipient);
            if (principal != null) {
                all.add(principal.getName());
                continue;
            }
            NuxeoGroup group = this.userManager.getGroup(recipient);
            if (group == null) continue;
            List memberUsers = group.getMemberUsers();
            all.addAll(memberUsers);
        }
        return all.size();
    }

    public Integer getWarningLimit() {
        return Integer.parseInt(Framework.getProperty((String)"ottc.collab.mail.warningLimit", (String)"1000"));
    }

    public String redirect(String viewId) {
        return viewId;
    }

    public String send(String viewId) {
        String view = super.send();
        if (view != null) {
            this.pageBean.setNotificationKey("SUCCESS_MAIL_SENT");
            view = viewId;
        }
        return view;
    }
}

