/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.core.listener;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class AcrennesSetOrganisationSource
implements EventListener {
    private static final Log log = LogFactory.getLog(AcrennesSetOrganisationSource.class);

    public void handleEvent(Event event) throws ClientException {
        boolean doSaveDocument = false;
        if (event.getContext() instanceof DocumentEventContext) {
            DocumentEventContext eventContext = (DocumentEventContext)event.getContext();
            String eventName = event.getName();
            DocumentModel doc = eventContext.getSourceDocument();
            CoreSession session = eventContext.getCoreSession();
            if (doc.isProxy()) {
                return;
            }
            try {
                String srcOrg;
                DocumentModel parentDoc;
                if (doc.hasSchema("acaren") && !doc.hasFacet("OrganisationSource") && null != (parentDoc = session.getParentDocument(doc.getRef())) && parentDoc.hasSchema("acaren") && StringUtils.isNotBlank((String)(srcOrg = (String)((Object)parentDoc.getPropertyValue("acr:publisher"))))) {
                    doc.setPropertyValue("acr:publisher", (Serializable)((Object)srcOrg));
                    doSaveDocument = true;
                }
                if (doc.hasSchema("dublincore") && !"beforeDocumentModification".equals(eventName) && (ToutaticeDocumentHelper.isASpaceDocument((DocumentModel)doc) || ToutaticeDocumentHelper.isASuperSpaceDocument((DocumentModel)doc))) {
                    doSaveDocument = this.initialiseDcPublisher(doc, session);
                }
                if (doSaveDocument && !"beforeDocumentModification".equals(eventName)) {
                    session.saveDocument(doc);
                }
            }
            catch (Exception e) {
                log.debug((Object)("Failed to set the organisation source for the document '" + doc.getTitle() + "', error: " + e.getMessage()));
            }
        }
    }

    private boolean initialiseDcPublisher(DocumentModel doc, CoreSession session) {
        boolean doSaveDocument = false;
        String rne = (String)((Object)doc.getPropertyValue("dc:publisher"));
        Filter filter = new Filter(){
            private static final long serialVersionUID = 1L;

            public boolean accept(DocumentModel document) {
                boolean res = false;
                String dcpublisher = (String)((Object)document.getPropertyValue("dc:publisher"));
                if ((ToutaticeDocumentHelper.isASpaceDocument((DocumentModel)document) || ToutaticeDocumentHelper.isASuperSpaceDocument((DocumentModel)document)) && StringUtils.isNotBlank((String)dcpublisher)) {
                    res = true;
                }
                return res;
            }
        };
        DocumentModelList spaceParentsDoc = ToutaticeDocumentHelper.getParentList((CoreSession)session, (DocumentModel)doc, (Filter)filter, (boolean)true, (boolean)true, (boolean)false);
        rne = (String)((Object)((DocumentModel)spaceParentsDoc.get(0)).getPropertyValue("dc:publisher"));
        doc.setPropertyValue("dc:publisher", (Serializable)((Object)rne));
        doSaveDocument = true;
        return doSaveDocument;
    }
}

