/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.migration.runners;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.storage.StorageBlob;
import org.osivia.migration.runners.AbstractRunner;

public class PostAttachedFileRunner
extends AbstractRunner {
    private static final Log log = LogFactory.getLog(PostAttachedFileRunner.class);
    private static final String POSTS_WITH_ATTACHED_FILE_QUERY = "select * from Post where post:filename is not null";

    public PostAttachedFileRunner(CoreSession session) {
        super(session);
    }

    @Override
    public int setInputs(int limit) {
        int size = 0;
        this.inputs = this.session.query(POSTS_WITH_ATTACHED_FILE_QUERY, limit);
        size = this.inputs.size();
        return size;
    }

    @Override
    public void run() throws ClientException {
        for (DocumentModel post : this.inputs) {
            StorageBlob blobProp = (StorageBlob)post.getPropertyValue("post:fileContent");
            if (blobProp != null) {
                this.checkBlobProperties(post, blobProp);
                ArrayList files = new ArrayList(1);
                HashMap<String, String> file = new HashMap<String, String>(2);
                file.put("filename", blobProp.getFilename());
                file.put("file", (String)blobProp);
                files.add(file);
                post.setPropertyValue("files:files", files);
                post.setPropertyValue("post:fileContent", null);
            }
            post.setPropertyValue("post:filename", null);
            this.session.saveDocument(post);
            ++this.treatedInputs;
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)(post.getPathAsString() + " migrated"));
        }
        this.session.save();
    }

    protected void checkBlobProperties(DocumentModel post, StorageBlob blobProp) {
    }
}

