/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.migration.service;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationServiceHelper;
import org.nuxeo.ecm.platform.ec.placeful.Annotation;
import org.nuxeo.ecm.platform.ec.placeful.PlacefulServiceImpl;
import org.nuxeo.ecm.platform.ec.placeful.interfaces.PlacefulService;
import org.nuxeo.runtime.transaction.TransactionHelper;
import org.osivia.migration.persistence.ejb.OttcMigrations;
import org.osivia.migration.service.RunnerDescriptor;
import org.osivia.migration.transaction.LauncherTransactionHelper;

public class RunnerController {
    private static final Log log = LogFactory.getLog(RunnerController.class);

    private RunnerController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean needToMigrate(RunnerDescriptor runnerDescriptor) {
        boolean needs = false;
        LauncherTransactionHelper.checkNStartTransaction();
        try {
            PlacefulService pfService = NotificationServiceHelper.getPlacefulServiceBean();
            try {
                OttcMigrations ottcMigrations = (OttcMigrations)pfService.getAnnotation(runnerDescriptor.getRunnerId(), "OttcMigrations");
                needs = runnerDescriptor.isForce() || !"done".equalsIgnoreCase(ottcMigrations.getStatus());
            }
            catch (NoResultException nre) {
                OttcMigrations ottcMigrations = new OttcMigrations(runnerDescriptor.getRunnerId(), runnerDescriptor.getMigrationVersion());
                pfService.setAnnotation((Annotation)ottcMigrations);
                needs = true;
            }
        }
        catch (Exception e) {
            LauncherTransactionHelper.setTransactionRollbackOnly();
            RunnerController.logStackTrace(log, e);
            needs = false;
        }
        finally {
            LauncherTransactionHelper.commitOrRollbackTransaction();
        }
        return needs;
    }

    protected static void storeMigrationStatus(RunnerDescriptor runnerDescriptor) {
        LauncherTransactionHelper.checkNStartTransaction();
        boolean isTx = TransactionHelper.isTransactionActive();
        if (!isTx) {
            isTx = TransactionHelper.startTransaction();
        }
        try {
            PlacefulService pfService = NotificationServiceHelper.getPlacefulServiceBean();
            EntityManager entityManager = ((PlacefulServiceImpl)pfService).getOrCreatePersistenceProvider().acquireEntityManagerWithActiveTransaction();
            OttcMigrations notUpdatedEntity = (OttcMigrations)((Object)entityManager.getReference(OttcMigrations.class, (Object)runnerDescriptor.getRunnerId()));
            entityManager.remove((Object)notUpdatedEntity);
            if (isTx) {
                LauncherTransactionHelper.commitOrRollbackTransaction();
            }
            if (!TransactionHelper.isTransactionActive()) {
                LauncherTransactionHelper.checkNStartTransaction();
                if (!TransactionHelper.isTransactionActive()) {
                    isTx = TransactionHelper.startTransaction();
                }
            }
            OttcMigrations ottcMigrations = new OttcMigrations(runnerDescriptor.getRunnerId(), runnerDescriptor.getMigrationVersion());
            ottcMigrations.setStatus("done");
            pfService.setAnnotation((Annotation)ottcMigrations);
            if (isTx) {
                LauncherTransactionHelper.commitOrRollbackTransaction();
            }
        }
        catch (Exception e) {
            if (isTx) {
                LauncherTransactionHelper.setTransactionRollbackOnly();
            }
            log.error((Object)e);
        }
    }

    private static void logStackTrace(Log log, Throwable t) {
        StringWriter stringWritter = new StringWriter();
        PrintWriter printWritter = new PrintWriter((Writer)stringWritter, true);
        t.printStackTrace(printWritter);
        printWritter.flush();
        stringWritter.flush();
        log.error((Object)("[Error]: " + stringWritter.toString()));
    }
}

