/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.listener;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeNotifyEventHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeSilentProcessRunnerHelper;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.LifeCycleFilter;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class ToutaticePropagateSectionsAsynchronouslyListener
implements PostCommitEventListener {
    private static final Log log = LogFactory.getLog(ToutaticePropagateSectionsAsynchronouslyListener.class);
    private static final String[] ACCEPTED_LIFE_CYCLE_STATES = new String[]{"project", "approved"};

    public void handleEvent(EventBundle events) throws ClientException {
        for (Event event : events) {
            if (!"propagateSections".equals(event.getName())) continue;
            this.handleEventPropagateSections(event);
        }
    }

    public void handleEventPropagateSections(Event event) throws ClientException {
        boolean runInUnrestrictedMode = false;
        boolean doAppendSections = false;
        String sectionId = "ALL";
        if (event.getContext() instanceof DocumentEventContext) {
            DocumentEventContext eventContext = (DocumentEventContext)event.getContext();
            CoreSession session = eventContext.getCoreSession();
            DocumentModel document = eventContext.getSourceDocument();
            Map options = eventContext.getProperties();
            try {
                if (null != options) {
                    runInUnrestrictedMode = (Boolean)(options.containsKey("runUnrestricted") ? (Serializable)options.get("runUnrestricted") : Boolean.valueOf(false));
                    doAppendSections = (Boolean)(options.containsKey("append") ? (Serializable)options.get("append") : Boolean.valueOf(false));
                    sectionId = options.containsKey("ALL") ? (Serializable)options.get("ALL") : "ALL";
                }
                String[] sectionIdsList = null;
                sectionIdsList = !"ALL".equals(sectionId) ? new String[]{sectionId} : ToutaticeDocumentHelper.filterLifeCycleStateDocuments((CoreSession)session, (String[])((String[])document.getPropertyValue("publish:sections")), Arrays.asList(ACCEPTED_LIFE_CYCLE_STATES), null);
                if (null != sectionIdsList && 0 < sectionIdsList.length) {
                    PropagateSectionsRunner runner = new PropagateSectionsRunner(session, document, sectionIdsList, doAppendSections);
                    runner.silentRun(runInUnrestrictedMode);
                    ToutaticeNotifyEventHelper.notifyAuditEvent((CoreSession)session, (String)"propagateProcessCompleted", (DocumentModel)document, (String)String.format("Propagation des sections depuis '%s', mises \u00e0 jour '%s'", document.getTitle(), runner.getNbrUpdatedDocs()));
                } else {
                    ToutaticeNotifyEventHelper.notifyAuditEvent((CoreSession)session, (String)"propagateProcessCompleted", (DocumentModel)document, (String)String.format("Propagation des sections depuis '%s', mises \u00e0 jour '%s'", document.getTitle(), 0));
                }
            }
            catch (Exception e) {
                log.error((Object)("Failed to propagate the publication sections for the document '" + document.getTitle() + "', error: " + e.getMessage()));
            }
            log.info((Object)("Fin du processus de propagation des sections depuis l'espace de travail '" + document.getTitle() + "'"));
        }
    }

    private void updateSectionList(DocumentModel document, String[] sectionIdsList, boolean doAppend) throws ClientException {
        try {
            String[] documentSectionIds = (String[])document.getPropertyValue("publish:sections");
            if (null != documentSectionIds && 0 < documentSectionIds.length && doAppend) {
                int i;
                HashMap<String, String> sectionsIdMap = new HashMap<String, String>();
                for (i = 0; i < documentSectionIds.length; ++i) {
                    sectionsIdMap.put(documentSectionIds[i], "");
                }
                for (i = 0; i < sectionIdsList.length; ++i) {
                    sectionsIdMap.put(sectionIdsList[i], "");
                }
                document.setPropertyValue("publish:sections", (Serializable)sectionsIdMap.keySet().toArray(new String[sectionsIdMap.size()]));
            } else {
                document.setPropertyValue("publish:sections", (Serializable)sectionIdsList);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to set the sections list to the document '" + document.getTitle() + "', error: " + e.getMessage()));
        }
    }

    private class PublishingDocfilter
    implements Filter {
        private static final long serialVersionUID = 1L;

        private PublishingDocfilter() {
        }

        public boolean accept(DocumentModel document) {
            return document.hasSchema("publishing");
        }
    }

    private class EmptySectionsFieldfilter
    implements Filter {
        private static final long serialVersionUID = 976112236321715258L;
        CoreSession session;
        Filter lcFilter;

        public EmptySectionsFieldfilter(CoreSession session) {
            this.session = session;
            this.lcFilter = new LifeCycleFilter(Arrays.asList(ACCEPTED_LIFE_CYCLE_STATES), null);
        }

        public boolean accept(DocumentModel docModel) {
            boolean status;
            block4: {
                status = true;
                try {
                    if (!docModel.hasSchema("publishing")) {
                        status = false;
                        break block4;
                    }
                    String[] sectionIdsList = (String[])docModel.getPropertyValue("publish:sections");
                    if (sectionIdsList == null || sectionIdsList.length <= 0) break block4;
                    for (String sectionId : sectionIdsList) {
                        DocumentModel section = this.session.getDocument((DocumentRef)new IdRef(sectionId));
                        if (!this.lcFilter.accept(section)) continue;
                        status = false;
                        break;
                    }
                }
                catch (Exception e) {
                    status = false;
                }
            }
            return status;
        }
    }

    private class PropagateSectionsRunner
    extends ToutaticeSilentProcessRunnerHelper {
        private String[] sectionIdsList;
        private DocumentModel baseDocument;
        private int nbrUpdatedDocs;
        private boolean doAppendSections;

        public PropagateSectionsRunner(CoreSession session, DocumentModel baseDocument, String[] sectionIdsList, boolean doAppendSections) {
            super(session);
            this.baseDocument = baseDocument;
            this.sectionIdsList = sectionIdsList;
            this.nbrUpdatedDocs = 0;
            this.doAppendSections = doAppendSections;
        }

        public int getNbrUpdatedDocs() {
            return this.nbrUpdatedDocs;
        }

        public void run() throws ClientException {
            Object documentFilter = null;
            String query = "SELECT * FROM Document WHERE ecm:path STARTSWITH '%s' AND ecm:mixinType = 'Folderish' AND ecm:primaryType NOT IN ('SectionRoot', 'Section') AND ecm:mixinType != 'HiddenInNavigation' AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState != 'deleted' AND ecm:isProxy = 0";
            documentFilter = this.doAppendSections ? new PublishingDocfilter() : new EmptySectionsFieldfilter(this.session);
            String path = this.baseDocument.getPath().toString().replace("'", "\\'");
            DocumentModelList childDocumentList = this.session.query(String.format(query, path), (Filter)documentFilter);
            this.nbrUpdatedDocs = childDocumentList.size();
            for (DocumentModel childDocument : childDocumentList) {
                ToutaticePropagateSectionsAsynchronouslyListener.this.updateSectionList(childDocument, this.sectionIdsList, this.doAppendSections);
                this.session.saveDocument(childDocument);
            }
        }
    }
}

