/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk.comm;

import com.sun.jdmk.comm.CEStreamExhausted;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

abstract class CharacterDecoder {
    CharacterDecoder() {
    }

    protected abstract int bytesPerAtom();

    protected abstract int bytesPerLine();

    protected void decodeBufferPrefix(InputStream aStream, OutputStream bStream) throws IOException {
    }

    protected void decodeBufferSuffix(InputStream aStream, OutputStream bStream) throws IOException {
    }

    protected int decodeLinePrefix(InputStream aStream, OutputStream bStream) throws IOException {
        return this.bytesPerLine();
    }

    protected void decodeLineSuffix(InputStream aStream, OutputStream bStream) throws IOException {
    }

    protected void decodeAtom(InputStream aStream, OutputStream bStream, int l) throws IOException {
        throw new CEStreamExhausted();
    }

    protected int readFully(InputStream in, byte[] buffer, int offset, int len) throws IOException {
        int i = 0;
        while (i < len) {
            int q = in.read();
            if (q == -1) {
                return i == 0 ? -1 : i;
            }
            buffer[i + offset] = (byte)q;
            ++i;
        }
        return len;
    }

    public void decodeBuffer(InputStream aStream, OutputStream bStream) throws IOException {
        int totalBytes = 0;
        this.decodeBufferPrefix(aStream, bStream);
        try {
            while (true) {
                int length = this.decodeLinePrefix(aStream, bStream);
                int i = 0;
                while (i + this.bytesPerAtom() < length) {
                    this.decodeAtom(aStream, bStream, this.bytesPerAtom());
                    totalBytes += this.bytesPerAtom();
                    i += this.bytesPerAtom();
                }
                if (i + this.bytesPerAtom() == length) {
                    this.decodeAtom(aStream, bStream, this.bytesPerAtom());
                    totalBytes += this.bytesPerAtom();
                } else {
                    this.decodeAtom(aStream, bStream, length - i);
                    totalBytes += length - i;
                }
                this.decodeLineSuffix(aStream, bStream);
            }
        }
        catch (CEStreamExhausted cEStreamExhausted) {
            this.decodeBufferSuffix(aStream, bStream);
            return;
        }
    }

    public byte[] decodeBuffer(String inputString) throws IOException {
        byte[] inputBuffer = new byte[inputString.length()];
        inputBuffer = inputString.getBytes();
        ByteArrayInputStream inStream = new ByteArrayInputStream(inputBuffer);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        this.decodeBuffer(inStream, outStream);
        return outStream.toByteArray();
    }

    public byte[] decodeBuffer(InputStream in) throws IOException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        this.decodeBuffer(in, outStream);
        return outStream.toByteArray();
    }
}

