/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.procedures.record.query.automation;

import fr.toutatice.ecm.elasticsearch.query.TTCNxQueryBuilder;
import java.security.Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.index.query.AndFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.OrFilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.security.SecurityService;
import org.osivia.procedures.record.security.query.SecurityClauseBuilder;

public class SecurityNxQueryBuilder
extends TTCNxQueryBuilder {
    private static final Log log = LogFactory.getLog(SecurityNxQueryBuilder.class);

    public SecurityNxQueryBuilder(CoreSession session) {
        super(session);
        this.session = session;
    }

    protected QueryBuilder addSecurityFilter(QueryBuilder query) {
        long begin = System.currentTimeMillis();
        QueryBuilder securedQuery = query;
        AndFilterBuilder aclFilter = this.getDocumentACLFilter(query);
        if (aclFilter != null) {
            FilterBuilder recordsSecureFilter = SecurityClauseBuilder.getInstance().getFilter(this.session);
            if (recordsSecureFilter != null) {
                OrFilterBuilder aclNRecordsSecureFilter = FilterBuilders.orFilter((FilterBuilder[])new FilterBuilder[]{recordsSecureFilter, aclFilter});
                securedQuery = QueryBuilders.filteredQuery((QueryBuilder)query, (FilterBuilder)aclNRecordsSecureFilter);
            } else {
                securedQuery = QueryBuilders.filteredQuery((QueryBuilder)query, (FilterBuilder)aclFilter);
            }
        }
        if (log.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            log.debug((Object)("[#addSecurityFilter] " + String.valueOf(end - begin) + " ms"));
        }
        return securedQuery;
    }

    protected AndFilterBuilder getDocumentACLFilter(QueryBuilder query) {
        Principal principal = this.session.getPrincipal();
        if (principal == null || principal instanceof NuxeoPrincipal && ((NuxeoPrincipal)principal).isAdministrator()) {
            return null;
        }
        String[] principals = SecurityService.getPrincipalsToCheck((Principal)principal);
        AndFilterBuilder aclFilter = FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[]{FilterBuilders.inFilter((String)"ecm:acl", (String[])principals), FilterBuilders.notFilter((FilterBuilder)FilterBuilders.inFilter((String)"ecm:acl", (String[])new String[]{"_UNSUPPORTED_ACL_"}))});
        return aclFilter;
    }
}

