/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.procedures.record.security.rules;

import org.nuxeo.ecm.core.api.CoreSession;
import org.osivia.procedures.record.security.rules.Context;
import org.osivia.procedures.record.security.rules.model.SecurityRelation;
import org.osivia.procedures.record.security.rules.model.SecurityRelationType;
import org.osivia.procedures.record.security.rules.model.relation.RecordsRelation;
import org.osivia.procedures.record.security.rules.model.relation.RelationModelType;
import org.osivia.procedures.record.security.rules.model.type.Entity;

public class SecurityRelationsAdapter {
    private static SecurityRelationsAdapter instance;

    private SecurityRelationsAdapter() {
    }

    public static synchronized SecurityRelationsAdapter getInstance() {
        if (instance == null) {
            instance = new SecurityRelationsAdapter();
        }
        return instance;
    }

    public SecurityRelation adapt(CoreSession session, Context context, RecordsRelation recordsRelation) {
        SecurityRelation secureRelation = null;
        if (recordsRelation != null) {
            secureRelation = new SecurityRelation();
            secureRelation.setType(this.adapType(recordsRelation.getType()));
            secureRelation.setRelationKey(recordsRelation.getTargetKey());
            secureRelation.setEntity(session, this.adaptEntity(context, recordsRelation));
        }
        return secureRelation;
    }

    private SecurityRelationType adapType(RelationModelType recordsRelationType) {
        SecurityRelationType navType = null;
        switch (recordsRelationType) {
            case oneToOne: {
                navType = SecurityRelationType.NtoOne;
                break;
            }
            case oneToN: {
                navType = SecurityRelationType.NtoN;
                break;
            }
        }
        return navType;
    }

    private Entity adaptEntity(Context context, RecordsRelation recordsRelation) {
        Entity secureEntity = null;
        switch (context) {
            case inComingRelation: {
                secureEntity = recordsRelation.getSourceEntity();
                break;
            }
            case outComingRelation: {
                secureEntity = recordsRelation.getTargetEntity();
            }
        }
        return secureEntity;
    }
}

