/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.helper;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class ToutaticeImageCollectionHelper {
    private static final Map<String, Object> fakeItem = new HashMap<String, Object>(){
        {
            this.put("file", null);
            this.put("filename", null);
        }
    };
    private static ToutaticeImageCollectionHelper instance;

    private ToutaticeImageCollectionHelper() {
    }

    public boolean isFakeItem(Map<String, Object> item) {
        return fakeItem.equals(item);
    }

    public static ToutaticeImageCollectionHelper instance() {
        if (null == instance) {
            instance = new ToutaticeImageCollectionHelper();
        }
        return instance;
    }

    public boolean isEmpty(List<Map<String, Object>> list) {
        boolean status = list.isEmpty();
        if (!status) {
            status = true;
            for (Map<String, Object> item : list) {
                if (fakeItem.equals(item)) continue;
                status = false;
                break;
            }
        }
        return status;
    }

    public int size(List<Map<String, Object>> list) {
        int size = 0;
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> item = list.get(i);
            if (fakeItem.equals(item)) continue;
            ++size;
        }
        return size;
    }

    public boolean add(List<Map<String, Object>> list, Map<String, Object> e) {
        boolean status = false;
        if (list.isEmpty()) {
            status = list.add(e);
        } else {
            int index = 0;
            do {
                Map<String, Object> item;
                if (!fakeItem.equals(item = list.get(index))) continue;
                list.set(index, e);
                status = true;
                break;
            } while (++index < list.size());
            if (!status) {
                status = list.add(e);
            }
        }
        return status;
    }

    public Map<String, Object> remove(List<Map<String, Object>> list, int index) {
        Map<String, Object> item = null;
        if (index >= list.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (index == list.size() - 1) {
            item = list.remove(index);
            this.flushListTail(list);
        } else {
            item = list.set(index, fakeItem);
        }
        return item;
    }

    public boolean remove(List<Map<String, Object>> list, Object o) {
        boolean status = false;
        int index = list.indexOf(o);
        if (0 <= index) {
            this.remove(list, index);
            status = true;
        }
        return status;
    }

    private void flushListTail(List<Map<String, Object>> list) {
        Map<String, Object> item;
        for (int i = list.size() - 1; i >= 0 && fakeItem.equals(item = list.get(i)); --i) {
            list.remove(i);
        }
    }

    public Iterator<Map<String, Object>> iterator(List<Map<String, Object>> list) {
        ToutaticeImageCollectionHelper toutaticeImageCollectionHelper = instance;
        toutaticeImageCollectionHelper.getClass();
        return toutaticeImageCollectionHelper.new ToutaticeImageCollectionIterator(list);
    }

    private class ToutaticeImageCollectionIterator
    implements Iterator<Map<String, Object>> {
        private List<Map<String, Object>> list;
        private boolean opRemoveAlreadyCalled;
        private int index = 0;

        public ToutaticeImageCollectionIterator(List<Map<String, Object>> list) {
            this.list = list;
            this.opRemoveAlreadyCalled = false;
        }

        @Override
        public boolean hasNext() {
            boolean status = false;
            Map<String, Object> item = fakeItem;
            if (!ToutaticeImageCollectionHelper.instance().isEmpty(this.list)) {
                while (fakeItem.equals(item) && this.index < this.list.size()) {
                    item = this.list.get(this.index++);
                }
                if (!fakeItem.equals(item)) {
                    status = true;
                }
            }
            return status;
        }

        @Override
        public Map<String, Object> next() {
            this.opRemoveAlreadyCalled = false;
            if (0 == this.index || this.index > this.list.size()) {
                throw new NoSuchElementException();
            }
            return this.list.get(this.index - 1);
        }

        @Override
        public void remove() {
            if (this.opRemoveAlreadyCalled) {
                throw new IllegalStateException();
            }
            if (0 == this.index || this.index > this.list.size()) {
                throw new NoSuchElementException();
            }
            ToutaticeImageCollectionHelper.instance().remove(this.list, this.index - 1);
            this.opRemoveAlreadyCalled = true;
        }
    }
}

