/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.ecm.feature.news.model;

import fr.toutatice.ecm.platform.core.constants.ToutaticeGlobalConst;
import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeSilentProcessRunnerHelper;
import fr.toutatice.ecm.platform.core.query.helper.ToutaticeQueryHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;
import org.opentoutatice.ecm.feature.news.scanner.NewsUpdater;
import org.opentoutatice.ecm.feature.news.scanner.io.NewsPeriod;

public class SpaceMember {
    private DocumentModel userProfile;
    private Map<String, Serializable> data;
    private DocumentModel space;
    private CoreSession session;
    private static UserManager usrManager;
    private boolean hasUserProfile = true;
    private static final int UWS_NAME_MAX_SIZE;

    public SpaceMember() {
        this.data = new HashMap<String, Serializable>(0);
    }

    public SpaceMember(Map<String, Serializable> data) throws LoginException {
        this.hasUserProfile = this.initialize(data);
    }

    public CoreSession getSession() {
        return this.session;
    }

    public static UserManager getUsermanager() {
        if (usrManager == null) {
            usrManager = (UserManager)Framework.getService(UserManager.class);
        }
        return usrManager;
    }

    public boolean hasUserProfile() {
        return this.hasUserProfile;
    }

    private boolean initialize(Map<String, Serializable> data) throws LoginException {
        boolean initialized = false;
        this.data = data;
        String login = (String)((Object)data.get("ttcs:spaceMembers/*1/login"));
        Framework.loginAsUser((String)login);
        NuxeoPrincipal principal = SpaceMember.getUsermanager().getPrincipal(login);
        this.session = CoreInstance.openCoreSession(null, (NuxeoPrincipal)principal);
        this.userProfile = this.getUserProfileDocument(login, this.session);
        if (this.userProfile != null) {
            String spaceId = (String)((Object)this.data.get("ecm:uuid"));
            this.space = ToutaticeDocumentHelper.getUnrestrictedDocument((CoreSession)this.session, (String)spaceId);
            initialized = true;
        }
        return initialized;
    }

    private DocumentModel getUserProfileDocument(String login, CoreSession session) {
        DocumentModel userProfile = null;
        if (session != null) {
            DocumentModel uWsDoc;
            String query;
            DocumentModelList userProfiles;
            StringBuffer uWsPath;
            PathRef uWsRRef;
            DocumentModel uWsRoot = null;
            try {
                uWsRoot = NewsUpdater.getUserWorkspacesRoot();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (uWsRoot != null && session.exists((DocumentRef)(uWsRRef = new PathRef((uWsPath = new StringBuffer(uWsRoot.getPathAsString()).append("/").append(IdUtils.generateId((String)login, (String)"-", (boolean)false, (int)UWS_NAME_MAX_SIZE))).toString()))) && !(userProfiles = ToutaticeQueryHelper.queryUnrestricted((CoreSession)session, (String)(query = String.format("select * from %s where ecm:parentId='%s' and ecm:isProxy = 0 and ecm:isCheckedInVersion = 0 and ecm:currentLifeCycleState != 'deleted'", "UserProfile", (uWsDoc = ToutaticeDocumentHelper.getUnrestrictedDocument((CoreSession)session, (String)uWsPath.toString())).getId())))).isEmpty()) {
                userProfile = (DocumentModel)userProfiles.get(0);
            }
        }
        return userProfile;
    }

    public boolean hasSubscribed() {
        return (Boolean)this.userProfile.getPropertyValue("ttc_userprofile:newsSubscription");
    }

    public String getLogin() {
        return (String)((Object)this.data.get("ttcs:spaceMembers/*1/login"));
    }

    public String getSpaceId() {
        return (String)((Object)this.data.get("ecm:uuid"));
    }

    public String getSpaceTitle() {
        return (String)((Object)this.data.get("dc:title"));
    }

    public String getEmail() throws Exception {
        String email = null;
        String userName = (String)((Object)this.data.get("ttcs:spaceMembers/*1/login"));
        NuxeoPrincipal principal = SpaceMember.getUsermanager().getPrincipal(userName);
        if (principal == null) {
            throw new Exception(userName + " doesn't exist.");
        }
        email = principal.getEmail();
        return email;
    }

    public NewsPeriod getNewsPeriod() {
        NewsPeriod newsPeriod = null;
        String newsPeriodProp = (String)((Object)this.data.get("ttcs:spaceMembers/*1/newsPeriod"));
        newsPeriod = newsPeriodProp == null ? NewsPeriod.none : NewsPeriod.valueOf(newsPeriodProp);
        return newsPeriod;
    }

    public Date getNextNewsDate() {
        Date nextDate = null;
        GregorianCalendar calendar = (GregorianCalendar)this.data.get("ttcs:spaceMembers/*1/nextNewsDate");
        if (calendar != null) {
            nextDate = calendar.getTime();
        }
        return nextDate;
    }

    public void setNextNewsDate(int index, Date nextNewsDate) {
        Calendar calendar = null;
        if (nextNewsDate != null) {
            calendar = GregorianCalendar.getInstance();
            calendar.setTime(nextNewsDate);
        }
        this.data.put("ttcs:spaceMembers/*1/nextNewsDate", calendar);
        String dataLogin = (String)((Object)this.data.get("ttcs:spaceMembers/*1/login"));
        SilentUpdate update = new SilentUpdate(this.session, this.space, dataLogin, nextNewsDate, "nextNewsDate");
        update.silentRun(true, ToutaticeGlobalConst.EVENT_N_VERSIONING_FILTERD_SERVICE);
    }

    public Date getLastNewsDate() {
        Date lastDate = null;
        GregorianCalendar calendar = (GregorianCalendar)this.data.get("ttcs:spaceMembers/*1/lastNewsDate");
        if (calendar != null) {
            lastDate = calendar.getTime();
        }
        return lastDate;
    }

    public void setLastNewsDate(int index, Date lastNewsDate) {
        Calendar calendar = GregorianCalendar.getInstance();
        calendar.setTime(lastNewsDate);
        this.data.put("ttcs:spaceMembers/*1/lastNewsDate", calendar);
        String dataLogin = (String)((Object)this.data.get("ttcs:spaceMembers/*1/login"));
        SilentUpdate update = new SilentUpdate(this.session, this.space, dataLogin, lastNewsDate, "lastNewsDate");
        update.silentRun(true, ToutaticeGlobalConst.EVENT_N_VERSIONING_FILTERD_SERVICE);
    }

    private Map<String, Serializable> toProp(SpaceMember member) {
        HashMap<String, Serializable> prop = new HashMap<String, Serializable>(1);
        prop.put("login", this.data.get("ttcs:spaceMembers/*1/login"));
        prop.put("joinDate", this.data.get("ttcs:spaceMembers/*1/joinedDate"));
        prop.put("newsPeriod", this.data.get("ttcs:spaceMembers/*1/newsPeriod"));
        prop.put("lastNewsDate", this.data.get("ttcs:spaceMembers/*1/lastNewsDate"));
        prop.put("nextNewsDate", this.data.get("ttcs:spaceMembers/*1/nextNewsDate"));
        return prop;
    }

    static {
        UWS_NAME_MAX_SIZE = ((PathSegmentService)Framework.getService(PathSegmentService.class)).getMaxSize();
    }

    public static class SilentUpdate
    extends ToutaticeSilentProcessRunnerHelper {
        private DocumentModel space;
        private Date date;
        private String dataLogin;
        private String dateIdent;

        protected SilentUpdate(CoreSession session, DocumentModel document, String dataLogin, Date date, String dateIdent) {
            super(session);
            this.space = document;
            this.date = date;
            this.dataLogin = dataLogin;
            this.dateIdent = dateIdent;
        }

        public void run() throws ClientException {
            ArrayList props = (ArrayList)this.space.getPropertyValue("ttcs:spaceMembers");
            if (props != null) {
                for (Map prop : props) {
                    String login;
                    if (prop == null || !StringUtils.equals((String)this.dataLogin, (String)(login = (String)prop.get("login")))) continue;
                    prop.put(this.dateIdent, this.date);
                }
            }
            this.space.setPropertyValue("ttcs:spaceMembers", (Serializable)props);
            this.session.saveDocument(this.space);
            this.session.save();
        }
    }
}

