/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ec.notification;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.ec.notification.UserSubscription;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationService;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationServiceHelper;
import org.nuxeo.ecm.platform.ec.placeful.Annotation;
import org.nuxeo.ecm.platform.ec.placeful.interfaces.PlacefulService;

public class ProxySubscriptionPropagationListener
implements EventListener {
    private static final Log log = LogFactory.getLog(ProxySubscriptionPropagationListener.class);

    public void handleEvent(Event event) throws ClientException {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)ctx;
        DocumentModel publishedDoc = docCtx.getSourceDocument();
        if (!publishedDoc.isProxy()) {
            return;
        }
        NotificationService service = NotificationServiceHelper.getNotificationService();
        if (service == null) {
            log.error((Object)"Unable to get NotificationService, exiting");
            return;
        }
        List replacedProxyIds = (List)ctx.getProperties().get("replacedProxyRefs");
        if (replacedProxyIds == null) {
            return;
        }
        for (String replacedProxyId : replacedProxyIds) {
            try {
                this.propagateSubscription(replacedProxyId, publishedDoc.getRef().toString());
            }
            catch (Exception e) {
                throw new ClientException((Throwable)e);
            }
        }
    }

    protected void propagateSubscription(String fromDocId, String toDocId) throws Exception {
        PlacefulService service = NotificationServiceHelper.getPlacefulService();
        String className = (String)service.getAnnotationRegistry().get("UserSubscription");
        String shortClassName = className.substring(className.lastIndexOf(46) + 1);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (fromDocId != null) {
            paramMap.put("docId", fromDocId);
        }
        PlacefulService placefulService = NotificationServiceHelper.getPlacefulServiceBean();
        List subscriptions = placefulService.getAnnotationListByParamMap(paramMap, shortClassName);
        for (Object obj : subscriptions) {
            UserSubscription subscription = (UserSubscription)((Object)obj);
            subscription.setDocId(toDocId);
            placefulService.setAnnotation((Annotation)subscription);
        }
    }
}

