/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.service.url;

import fr.toutatice.ecm.platform.core.query.helper.ToutaticeEsQueryHelper;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.model.NoSuchDocumentException;

public class WebIdResolver {
    private static final Log log = LogFactory.getLog(WebIdResolver.class);
    public static final String RPXY_WID_MARKER = "_c_";

    private WebIdResolver() {
    }

    public static DocumentModel getLiveDocumentByWebId(CoreSession coreSession, String webId) throws NoSuchDocumentException {
        DocumentModel live = null;
        if (StringUtils.isNotBlank((String)webId)) {
            String query;
            DocumentModelList lives;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Resolving live document by webid: [".concat(webId).concat("]..."));
            }
            if (!CollectionUtils.isNotEmpty((Collection)(lives = ToutaticeEsQueryHelper.unrestrictedQuery((CoreSession)coreSession, (String)(query = String.format("select * from Document where ttc:webid = '%s' AND ecm:isVersion = 0 and ecm:isProxy = 0 ", webId)), (int)1))) || lives.size() != 1) {
                throw new NoSuchDocumentException(webId);
            }
            live = (DocumentModel)lives.get(0);
            if (log.isDebugEnabled()) {
                if (live != null) {
                    StringBuffer liveStr = new StringBuffer();
                    liveStr.append(live.getType()).append(" | ").append(live.getTitle() != null ? live.getTitle() : "").append(" | ").append(live.getPathAsString());
                    log.debug((Object)"Found live document with webId [".concat(webId).concat("]: ").concat("[").concat(liveStr.toString()).concat("]"));
                } else {
                    log.debug((Object)"No live document found with webId: [".concat(webId).concat("]"));
                }
            }
        }
        return live;
    }

    public static DocumentModelList getDocumentsByWebId(CoreSession coreSession, String webId) throws NoSuchDocumentException {
        DocumentModelList documents = null;
        if (StringUtils.isNotBlank((String)webId)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Resolving document by webid: [".concat(webId).concat("]..."));
            }
            UnrestrictedFecthWebIdRunner fecthWebIdRunner = new UnrestrictedFecthWebIdRunner(coreSession, webId);
            fecthWebIdRunner.runUnrestricted();
            documents = fecthWebIdRunner.getDocuments();
            if (CollectionUtils.isEmpty((Collection)documents) || CollectionUtils.isNotEmpty((Collection)documents) && documents.size() > 1) {
                throw new NoSuchDocumentException(webId);
            }
            if (log.isDebugEnabled()) {
                DocumentModel doc_ = (DocumentModel)documents.get(0);
                if (doc_ != null) {
                    StringBuffer liveStr = new StringBuffer();
                    liveStr.append(doc_.getType()).append(" | ").append(doc_.getTitle() != null ? doc_.getTitle() : "").append(" | ").append(doc_.getPathAsString());
                    log.debug((Object)"Found live document with webId [".concat(webId).concat("]: ").concat("[").concat(liveStr.toString()).concat("]"));
                } else {
                    log.debug((Object)"No live document found with webId: [".concat(webId).concat("]"));
                }
            }
        }
        return documents;
    }

    private static class UnrestrictedFecthWebIdRunner
    extends UnrestrictedSessionRunner {
        String webId;
        DocumentModelList documents;

        public UnrestrictedFecthWebIdRunner(CoreSession session, String webId) {
            super(session);
            this.webId = webId;
            this.documents = new DocumentModelListImpl();
        }

        public void run() throws ClientException {
            if (StringUtils.contains((String)this.webId, (String)WebIdResolver.RPXY_WID_MARKER)) {
                this.getRemoteProxy();
            } else {
                this.getLive();
            }
        }

        private void getRemoteProxy() {
            String[] webIds = StringUtils.splitByWholeSeparator((String)this.webId, (String)WebIdResolver.RPXY_WID_MARKER);
            String liveWId = webIds[0];
            String sectionWId = webIds[1];
            DocumentModelList rProxies = ToutaticeEsQueryHelper.unrestrictedQuery((CoreSession)this.session, (String)String.format("select * from Document where ttc:webid = '%s' AND ecm:isVersion = 0 and (ecm:isProxy = 1 and ecm:mixinType = 'isRemoteProxy') ", liveWId), (int)1);
            if (rProxies.size() == 1) {
                DocumentModel rPxy = (DocumentModel)rProxies.get(0);
                if (this.isParentWebId(rPxy, sectionWId)) {
                    this.documents.add((Object)rPxy);
                }
            } else if (rProxies.size() > 1) {
                for (DocumentModel rPxy : rProxies) {
                    if (!this.isParentWebId(rPxy, sectionWId)) continue;
                    this.documents.add((Object)rPxy);
                }
            }
        }

        private void getLive() {
            DocumentModelList lives = ToutaticeEsQueryHelper.unrestrictedQuery((CoreSession)this.session, (String)String.format("select * from Document where ttc:webid = '%s' AND ecm:isVersion = 0 and ecm:isProxy = 0 ", this.webId), (int)1);
            if (CollectionUtils.isNotEmpty((Collection)lives) && lives.size() == 1) {
                this.documents.add(lives.get(0));
            }
        }

        public boolean isParentWebId(DocumentModel document, String webId) {
            DocumentModel parentDocument;
            boolean is = false;
            if (document != null && (parentDocument = this.session.getParentDocument(document.getRef())) != null) {
                String pWebId = (String)((Object)parentDocument.getPropertyValue("ttc:webid"));
                is = StringUtils.equals((String)webId, (String)pWebId);
            }
            return is;
        }

        public DocumentModelList getDocuments() {
            return this.documents;
        }
    }
}

