/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.services.listeemargement.ecm.actions;

import fr.toutatice.services.listeemargement.ecm.actions.LECVActions;
import java.io.Serializable;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.webapp.base.InputController;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;

@Name(value="leCVActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class LECVActionsBean
extends InputController
implements LECVActions,
Serializable {
    private static final long serialVersionUID = 1L;
    private static String LISTE_DOC_TYPE = "ListeEmargement";
    @In(create=true)
    protected transient DocumentsListsManager documentsListsManager;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;

    public boolean getCanCreate() throws ClientException {
        return this.isNotLockedOrIsLockOwner(this.navigationContext.getCurrentDocument());
    }

    @Override
    public boolean getCanDelete() throws ClientException {
        boolean status = false;
        if (this.isNotLockedOrIsLockOwner(this.navigationContext.getCurrentDocument())) {
            List docs = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
            for (DocumentModel doc : docs) {
                if (LISTE_DOC_TYPE.equals(doc.getType())) {
                    String lcs = this.documentManager.getCurrentLifeCycleState(doc.getRef());
                    if (this.documentManager.hasPermission(doc.getRef(), "le_administrate") || "le_submitted".equals(lcs)) {
                        status = this.isNotLockedOrIsLockOwner(doc);
                        if (status) continue;
                        break;
                    }
                    status = false;
                    break;
                }
                status = false;
                break;
            }
        }
        return status;
    }

    @Override
    public boolean getCanValidate() throws ClientException {
        boolean status = false;
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        DocumentModel parentDoc = this.documentManager.getParentDocument(currentDoc.getRef());
        if (this.isNotLockedOrIsLockOwner(parentDoc)) {
            status = this.getCanValidate(currentDoc);
        }
        return status;
    }

    public boolean getCanValidate(DocumentModel document) throws ClientException {
        return this.isNotLockedOrIsLockOwner(document);
    }

    @Override
    public boolean getCanValidateSelection() throws ClientException {
        boolean status = false;
        if (this.isNotLockedOrIsLockOwner(this.navigationContext.getCurrentDocument())) {
            List docs = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
            for (DocumentModel doc : docs) {
                if (LISTE_DOC_TYPE.equals(doc.getType())) {
                    status = this.getCanValidate(doc);
                    if (status) continue;
                    break;
                }
                status = false;
                break;
            }
        }
        return status;
    }

    @Override
    public boolean getCanModify() throws ClientException {
        return this.isNotLockedOrIsLockOwner(this.navigationContext.getCurrentDocument());
    }

    @Override
    public boolean getCanIntegrate() throws ClientException {
        boolean status = false;
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        DocumentModel parentDoc = this.documentManager.getParentDocument(currentDoc.getRef());
        if (this.isNotLockedOrIsLockOwner(parentDoc)) {
            status = this.getCanIntegrate(currentDoc);
        }
        return status;
    }

    public boolean getCanIntegrate(DocumentModel document) throws ClientException {
        return this.isNotLockedOrIsLockOwner(document);
    }

    @Override
    public boolean getCanIntegrateSelection() throws ClientException {
        boolean status = false;
        if (this.isNotLockedOrIsLockOwner(this.navigationContext.getCurrentDocument())) {
            List docs = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
            for (DocumentModel doc : docs) {
                if (LISTE_DOC_TYPE.equals(doc.getType())) {
                    status = this.getCanIntegrate(doc);
                    if (status) continue;
                    break;
                }
                status = false;
                break;
            }
        }
        return status;
    }

    private boolean isNotLockedOrIsLockOwner(DocumentModel document) throws ClientException {
        Lock lockInfo = document.getLockInfo();
        return null != lockInfo ? lockInfo.getOwner().equals(this.currentUser.getName()) : true;
    }
}

