/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.repository.service;

import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.annotations.api.AnnotationException;
import org.nuxeo.ecm.platform.annotations.repository.URNDocumentViewTranslator;
import org.nuxeo.ecm.platform.annotations.repository.service.AnnotationsRepositoryService;
import org.nuxeo.ecm.platform.annotations.service.AnnotabilityManager;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.runtime.api.Framework;

public class RepositoryAnnotabilityManager
implements AnnotabilityManager {
    private static final Log log = LogFactory.getLog(RepositoryAnnotabilityManager.class);
    private final URNDocumentViewTranslator translator = new URNDocumentViewTranslator();
    private AnnotationsRepositoryService service;

    public RepositoryAnnotabilityManager() {
        try {
            this.service = (AnnotationsRepositoryService)Framework.getService(AnnotationsRepositoryService.class);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isAnnotable(URI uri) throws AnnotationException {
        DocumentView view = this.translator.getDocumentViewFromUri(uri);
        if (view == null) {
            try {
                return this.service.isAnnotable(null);
            }
            catch (ClientException e) {
                throw new AnnotationException((Throwable)e);
            }
        }
        try (CoreSession session = CoreInstance.openCoreSession(null);){
            DocumentModel model = session.getDocument(view.getDocumentLocation().getDocRef());
            boolean bl = this.service.isAnnotable(model);
            return bl;
        }
        catch (Exception e) {
            throw new AnnotationException((Throwable)e);
        }
    }
}

