/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.faceted.search.api.util;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.PropertyException;

public class JSONMetadataHelper {
    public static DocumentModel setPropertiesFromJson(DocumentModel doc, String json) throws JSONException, PropertyException, ClientException {
        JSONObject jsonObject = new JSONObject(new JSONTokener(json));
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            doc.setPropertyValue(key, JSONMetadataHelper.getValue(jsonObject.get(key)));
        }
        return doc;
    }

    protected static Serializable getValue(Object o) throws JSONException {
        if (o instanceof String) {
            Calendar calendar = null;
            try {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZ");
                Date date = df.parse((String)o);
                calendar = Calendar.getInstance();
                calendar.setTime(date);
            }
            catch (ParseException df) {
                // empty catch block
            }
            if (calendar != null) {
                return calendar;
            }
            return (Serializable)o;
        }
        if (o instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)o;
            ArrayList<Serializable> list = new ArrayList<Serializable>();
            for (int i = 0; i < jsonArray.length(); ++i) {
                list.add(JSONMetadataHelper.getValue(jsonArray.get(i)));
            }
            return list;
        }
        if (o instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)o;
            HashMap<String, Serializable> map = new HashMap<String, Serializable>();
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                map.put(key, JSONMetadataHelper.getValue(jsonObject.get(key)));
            }
            return map;
        }
        return (Serializable)o;
    }
}

