/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pictures.tiles.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.pictures.tiles.service.PictureTilingCacheInfo;
import org.nuxeo.ecm.platform.pictures.tiles.service.PictureTilingComponent;

public class PictureTilingCacheGCManager {
    public static final String MAX_DISK_SPACE_USAGE_KEY = "MaxDiskSpaceUsageForCache";
    public static final long MAX_DISK_SPACE_USAGE_KB = 1000L;
    private static final Log log = LogFactory.getLog(PictureTilingCacheGCManager.class);
    private static int gcRuns = 0;
    private static int gcCalls = 0;

    protected static long getMaxDiskSpaceUsageKB() {
        String maxStr = PictureTilingComponent.getEnvValue(MAX_DISK_SPACE_USAGE_KEY, Long.toString(1000L));
        return Long.parseLong(maxStr);
    }

    public static int getGCRuns() {
        return gcRuns;
    }

    public static int getGCCalls() {
        return gcCalls;
    }

    public static long getCacheSizeInKBs() {
        return PictureTilingCacheGCManager.getCacheSizeInBytes() / 1000L;
    }

    public static long getCacheSizeInBytes() {
        long totalSize = 0L;
        Map<String, PictureTilingCacheInfo> cache = PictureTilingComponent.getCache();
        for (String key : cache.keySet()) {
            PictureTilingCacheInfo cacheEntry = cache.get(key);
            totalSize += cacheEntry.getDiskSpaceUsageInBytes();
        }
        return totalSize;
    }

    public static boolean gcIfNeeded() {
        ++gcCalls;
        log.debug((Object)"GC Thread awake, see if there is some work to be done");
        long totalSize = PictureTilingCacheGCManager.getCacheSizeInKBs();
        long limit = PictureTilingCacheGCManager.getMaxDiskSpaceUsageKB();
        if (totalSize < limit) {
            log.debug((Object)"No GC needed, go back to sleep for now");
            return false;
        }
        long deltaInKB = totalSize - limit;
        log.debug((Object)("GC needed to free " + deltaInKB + " KB of data"));
        PictureTilingCacheGCManager.doGC(deltaInKB);
        log.debug((Object)"GC terminated");
        return true;
    }

    public static void doGC(long deltaInKB) {
        ++gcRuns;
        Map<String, PictureTilingCacheInfo> cache = PictureTilingComponent.getCache();
        HashMap<Date, String> sortingMap = new HashMap<Date, String>();
        for (String key : cache.keySet()) {
            PictureTilingCacheInfo cacheEntry = cache.get(key);
            sortingMap.put(cacheEntry.getLastAccessedTime(), key);
        }
        ArrayList accesTimeList = new ArrayList();
        accesTimeList.addAll(sortingMap.keySet());
        Collections.sort(accesTimeList);
        long deletedVolume = 0L;
        for (Date accessDate : accesTimeList) {
            PictureTilingCacheInfo cacheEntry = cache.get(sortingMap.get(accessDate));
            long deletePotential = cacheEntry.getDiskSpaceUsageInBytes() / 1024L;
            if (deletePotential > deltaInKB - deletedVolume) {
                cacheEntry.partialCleanUp(deltaInKB - deletedVolume + 1L);
                return;
            }
            cacheEntry.cleanUp();
            cache.remove(accessDate);
            if ((deletedVolume += deletePotential) <= deltaInKB) continue;
            break;
        }
    }
}

