/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.adapter.agenda;

import fr.toutatice.ecm.platform.core.helper.ToutaticeSilentProcessRunnerHelper;
import fr.toutatice.ecm.platform.service.portalviews.adapter.WidgetsAdapterService;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.runtime.api.Framework;

public class WidgetsAgendaAdapterListener
implements EventListener {
    public static final String CST_DOC_SCHEMA_TTC_EVENT = "toutatice_event";
    public static final String CST_DOC_SCHEMA_TTC_EVENT_PREFIX = "ttcevt";
    public static final String CST_DOC_XPATH_TTC_EVT_DATE_BEGIN = "ttcevt:dateBegin";
    public static final String CST_DOC_XPATH_TTC_EVT_TIME_BEGIN = "ttcevt:timeBegin";
    public static final String CST_DOC_XPATH_TTC_EVT_DATE_END = "ttcevt:dateEnd";
    public static final String CST_DOC_XPATH_TTC_EVT_TIME_END = "ttcevt:timeEnd";
    public static final String CST_DOC_SCHEMA_ALERTE = "alerte";
    public static final String CST_DOC_SCHEMA_ALERTE_PREFIX = "alert";
    public static final String CST_DOC_XPATH_ALERTE_DEBUT = "alert:dateDebut";
    public static final String CST_DOC_XPATH_ALERTE_FIN = "alert:dateFin";
    public static final String CST_DOC_SCHEMA_VEVENT = "vevent";
    public static final String CST_DOC_SCHEMA_VEVENT_PREFIX = "vevent";
    public static final String CST_DOC_XPATH_VEVENT_DEBUT = "vevent:dtstart";
    public static final String CST_DOC_XPATH_VEVENT_FIN = "vevent:dtend";
    public static final String CST_DOC_XPATH_VEVENT_ALLDAY = "vevent:allDay";
    public static final String DATE_FORMAT = "dd/MM/yyyy";
    public static final String TIME_FORMAT = "HH:mm";

    public void handleEvent(Event event) throws ClientException {
        String eventName;
        if (event.getContext() instanceof DocumentEventContext && ("documentCreated".equals(eventName = event.getName()) || "beforeDocumentModification".equals(eventName))) {
            EventContext ctx = event.getContext();
            DocumentEventContext docCtx = (DocumentEventContext)event.getContext();
            DocumentModel document = docCtx.getSourceDocument();
            CoreSession session = ctx.getCoreSession();
            if (document != null && !document.isImmutable() && document.hasSchema(CST_DOC_SCHEMA_TTC_EVENT)) {
                DateNTimeSilentFiller runner = new DateNTimeSilentFiller(session, document, eventName);
                runner.silentRun(false);
            }
        }
    }

    private class DateNTimeSilentFiller
    extends ToutaticeSilentProcessRunnerHelper {
        SimpleDateFormat format;
        SimpleDateFormat formatDate;
        SimpleDateFormat formatHour;
        private DocumentModel document;
        private String eventName;

        public DateNTimeSilentFiller(CoreSession session, DocumentModel document, String eventName) {
            super(session);
            this.document = document;
            this.eventName = eventName;
            this.format = new SimpleDateFormat("dd/MM/yyyy HH:mm");
            this.formatDate = new SimpleDateFormat(WidgetsAgendaAdapterListener.DATE_FORMAT);
            this.formatHour = new SimpleDateFormat(WidgetsAgendaAdapterListener.TIME_FORMAT);
        }

        public void run() throws ClientException {
            boolean isChangeableDocument = "documentCreated".equals(this.eventName);
            WidgetsAdapterService waService = (WidgetsAdapterService)Framework.getService(WidgetsAdapterService.class);
            if (waService.isInPortalViewContext()) {
                try {
                    this.fromTTCToNxDate();
                }
                catch (ParseException e) {
                    throw new ClientException((Throwable)e);
                }
            } else {
                this.fromNxToTTCDate();
            }
            if (isChangeableDocument) {
                this.session.saveDocument(this.document);
            }
        }

        private void fromTTCToNxDate() throws ParseException {
            String beginDate = (String)((Object)this.document.getPropertyValue(WidgetsAgendaAdapterListener.CST_DOC_XPATH_TTC_EVT_DATE_BEGIN));
            String beginTime = (String)((Object)this.document.getPropertyValue(WidgetsAgendaAdapterListener.CST_DOC_XPATH_TTC_EVT_TIME_BEGIN));
            String endDate = (String)((Object)this.document.getPropertyValue(WidgetsAgendaAdapterListener.CST_DOC_XPATH_TTC_EVT_DATE_END));
            String endTime = (String)((Object)this.document.getPropertyValue(WidgetsAgendaAdapterListener.CST_DOC_XPATH_TTC_EVT_TIME_END));
            String beginField = "";
            String endField = "";
            if (this.document.getType().equals("VEVENT")) {
                if (Boolean.valueOf(this.document.getPropertyValue(WidgetsAgendaAdapterListener.CST_DOC_XPATH_VEVENT_ALLDAY).toString()).booleanValue()) {
                    beginTime = "00:00";
                    endTime = "00:00";
                    Date parse = this.formatDate.parse(endDate);
                    Calendar c = Calendar.getInstance();
                    c.setTime(parse);
                    c.add(5, 1);
                    parse = c.getTime();
                    endDate = this.formatDate.format(parse);
                }
                beginField = WidgetsAgendaAdapterListener.CST_DOC_XPATH_VEVENT_DEBUT;
                endField = WidgetsAgendaAdapterListener.CST_DOC_XPATH_VEVENT_FIN;
            } else if (this.document.getType().equals("Alerte")) {
                beginField = WidgetsAgendaAdapterListener.CST_DOC_XPATH_ALERTE_DEBUT;
                endField = WidgetsAgendaAdapterListener.CST_DOC_XPATH_ALERTE_FIN;
            }
            Date begin = this.format.parse(beginDate + " " + beginTime);
            this.document.setPropertyValue(beginField, (Serializable)begin);
            Date end = this.format.parse(endDate + " " + endTime);
            this.document.setPropertyValue(endField, (Serializable)end);
        }

        private void fromNxToTTCDate() {
            GregorianCalendar nxDateTimeEnd;
            String beginField = "";
            String endField = "";
            if (this.document.getType().equals("VEVENT")) {
                beginField = WidgetsAgendaAdapterListener.CST_DOC_XPATH_VEVENT_DEBUT;
                endField = WidgetsAgendaAdapterListener.CST_DOC_XPATH_VEVENT_FIN;
            } else if (this.document.getType().equals("Alerte")) {
                beginField = WidgetsAgendaAdapterListener.CST_DOC_XPATH_ALERTE_DEBUT;
                endField = WidgetsAgendaAdapterListener.CST_DOC_XPATH_ALERTE_FIN;
            }
            GregorianCalendar nxDateTimeStart = (GregorianCalendar)this.document.getPropertyValue(beginField);
            if (null != nxDateTimeStart) {
                String beginDate = this.formatDate.format(nxDateTimeStart.getTime());
                String beginTime = this.formatHour.format(nxDateTimeStart.getTime());
                this.document.setPropertyValue(WidgetsAgendaAdapterListener.CST_DOC_XPATH_TTC_EVT_DATE_BEGIN, (Serializable)((Object)beginDate));
                this.document.setPropertyValue(WidgetsAgendaAdapterListener.CST_DOC_XPATH_TTC_EVT_TIME_END, (Serializable)((Object)beginTime));
            }
            if (null != (nxDateTimeEnd = (GregorianCalendar)this.document.getPropertyValue(endField))) {
                String endDate = this.formatDate.format(nxDateTimeEnd.getTime());
                String endTime = this.formatHour.format(nxDateTimeEnd.getTime());
                this.document.setPropertyValue(WidgetsAgendaAdapterListener.CST_DOC_XPATH_TTC_EVT_DATE_END, (Serializable)((Object)endDate));
                this.document.setPropertyValue(WidgetsAgendaAdapterListener.CST_DOC_XPATH_TTC_EVT_TIME_END, (Serializable)((Object)endTime));
            }
        }
    }
}

