/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.migration.runners;

import fr.toutatice.ecm.platform.core.freemarker.ToutaticeFunctions;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.osivia.migration.runners.AbstractRunner;
import org.osivia.migration.service.rest.BatchMode;

public class AnnoncesRunner
extends AbstractRunner {
    private static final Log log = LogFactory.getLog(AnnoncesRunner.class);
    private static final String LIVE_ANNONCES_QUERY = "select * from Annonce where ecm:isProxy = 0 AND ecm:isVersion = 0 and dc:created > timestamp '2017-10-25 00:00:00' and ecm:currentLifeCycleState <> 'deleted' order by dc:title";
    private static final String DC_DESCRIPTION = "dc:description";
    private static final int MAX_DESC_SIZE = 300;
    private static final String TRUNCATED_TEXT_SUFFIX = " ...";
    private int offset = 0;
    private static final ToutaticeFunctions fn = new ToutaticeFunctions();

    public AnnoncesRunner(CoreSession session) {
        super(session);
    }

    @Override
    public int setInputs(int limit) {
        int size = 0;
        this.inputs = this.session.query(LIVE_ANNONCES_QUERY, null, (long)limit, (long)this.offset, true);
        size = this.inputs.size();
        this.offset += limit;
        return size;
    }

    @Override
    public void run() throws ClientException {
        boolean execMode = StringUtils.equals((String)BatchMode.execute.name(), (String)super.getMode());
        for (DocumentModel doc : this.inputs) {
            List versions;
            String desc = (String)((Object)doc.getPropertyValue(DC_DESCRIPTION));
            if (desc == null || desc.length() <= 0) continue;
            if (StringUtils.endsWith((String)desc, (String)TRUNCATED_TEXT_SUFFIX)) {
                desc = StringUtils.substringBeforeLast((String)desc, (String)TRUNCATED_TEXT_SUFFIX);
            }
            if (desc.length() <= 300) continue;
            desc = fn.truncateTextFromHTML(desc, 300);
            if (execMode) {
                doc.setPropertyValue(DC_DESCRIPTION, (Serializable)((Object)desc));
                this.session.saveDocument(doc);
            }
            ++this.treatedInputs;
            ++this.totalInputs;
            if (log.isDebugEnabled()) {
                String msg = execMode ? " fixed " : "";
                log.debug((Object)("[Live]: " + doc.getPathAsString() + msg));
                msg = execMode ? "Description fixed as: \n" : "Description wil be fixed as: \n";
                log.debug((Object)(msg + desc));
            }
            if ((versions = this.session.getVersions(doc.getRef())).isEmpty()) continue;
            if (log.isDebugEnabled()) {
                String msg = execMode ? "[Treating its versions]: " : "[Versions of " + doc.getName() + " to treat]: ";
                log.debug((Object)msg);
            }
            for (DocumentModel version : versions) {
                version.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
                if (execMode) {
                    version.setPropertyValue(DC_DESCRIPTION, (Serializable)((Object)desc));
                    this.session.saveDocument(version);
                }
                ++this.treatedInputs;
                ++this.totalInputs;
                if (!log.isDebugEnabled()) continue;
                String vLabel = version.getVersionLabel() != null ? version.getVersionLabel() : " - no version -";
                String msg = execMode ? " fixed " : "";
                log.debug((Object)("[Version]: " + vLabel + msg));
            }
        }
        if (execMode) {
            this.session.save();
        }
    }
}

