/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.migration.runners;

import fr.toutatice.ecm.platform.collab.tools.forum.ThreadUpdateListener;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelIterator;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.EventListenerDescriptor;
import org.nuxeo.ecm.platform.comment.api.CommentManager;
import org.nuxeo.runtime.api.Framework;
import org.osivia.migration.runners.AbstractRunner;

public class ForumsRunner
extends AbstractRunner {
    private static final Log log = LogFactory.getLog(ForumsRunner.class);
    private static final String FORUMS_QUERY = "select ecm:uuid from Forum where ecm:isVersion = 0";
    private static EventService eventService;
    protected static CommentManager commentManager;

    public ForumsRunner(CoreSession session) {
        super(session);
    }

    @Override
    public int setInputs(int limit) {
        this.results = this.session.queryAndFetch(FORUMS_QUERY, "NXQL", new Object[0]);
        return new Long(this.results.size()).intValue();
    }

    protected EventService getEventService() {
        if (eventService == null) {
            eventService = (EventService)Framework.getService(EventService.class);
        }
        return eventService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() throws ClientException {
        try {
            if (this.results == null) return;
            Iterator iterator = this.results.iterator();
            while (iterator.hasNext()) {
                try {
                    DocumentModelIterator threadIterator;
                    String forumId = (String)((Map)iterator.next()).get("ecm:uuid");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("[Forum: " + forumId + "] treating"));
                    }
                    if ((threadIterator = this.session.getChildrenIterator((DocumentRef)new IdRef(forumId), "Thread")) != null) {
                        while (threadIterator.hasNext()) {
                            DocumentModel thread = (DocumentModel)threadIterator.next();
                            if (!"Thread".equals(thread.getType())) continue;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("[Thread: " + thread.getTitle() + "] treating"));
                            }
                            EventListenerDescriptor threadUpdater = this.getEventService().getEventListener("ottcThreadUpdateListener");
                            EventListener threadUpdateListener = threadUpdater.asEventListener();
                            ((ThreadUpdateListener)threadUpdateListener).updateAnswersOfThread(thread, this.session);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("[Thread: " + thread.getTitle() + "] treated"));
                        }
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("[Forum: " + forumId + "] treated"));
                }
                catch (Exception e) {
                    throw new ClientException((Throwable)e);
                    return;
                }
            }
        }
        finally {
            if (this.results != null) {
                this.results.close();
            }
        }
    }
}

