/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.migration.runners;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.runtime.api.Framework;
import org.osivia.migration.runners.AbstractRunner;
import org.osivia.migration.service.rest.BatchMode;

public class PortalSiteThumbnailRunner
extends AbstractRunner {
    private static final Log log = LogFactory.getLog(PortalSiteThumbnailRunner.class);
    private static final String LIVE_PSP_QUERY = "SELECT * FROM PortalSite WHERE ecm:isProxy = 0 AND ecm:isVersion = 0 AND ecm:currentLifeCycleState <> 'deleted' and ttcn:picture/data is not null and ttc:vignette/data is null";
    private static final String PROXY_PSP_RECOVERY_QUERY = "SELECT * FROM PortalSite WHERE ecm:isProxy = 1 AND ecm:currentLifeCycleState <> 'deleted' and ttcn:picture/data is not null and ttc:vignette/data is null";
    private static final AutomationService service = (AutomationService)Framework.getService(AutomationService.class);

    public PortalSiteThumbnailRunner(CoreSession session) {
        super(session);
    }

    @Override
    public int setInputs(int limit) {
        String query = BatchMode.recovery.name().equals(this.getMode()) ? PROXY_PSP_RECOVERY_QUERY : LIVE_PSP_QUERY;
        this.inputs = this.session.query(query, limit);
        this.inputs = this.removeDocsWithError(this.inputs);
        int size = this.inputs.size();
        this.totalInputs += size;
        return size;
    }

    @Override
    public void run() throws ClientException {
        if (!BatchMode.recovery.name().equals(this.getMode())) {
            for (DocumentModel ps : this.inputs) {
                try {
                    log.info((Object)String.format("Treating PS: [%s]", ps.getPathAsString()));
                    DocumentModel treatedPs = this.resizePictureToThumbnail(ps);
                    if (treatedPs == null) continue;
                    DocumentModel proxy = ToutaticeDocumentHelper.getProxy((CoreSession)this.session, (DocumentModel)(treatedPs = this.session.saveDocument(treatedPs)), null);
                    if (proxy != null) {
                        log.debug((Object)String.format("Published: treating last version of [%s]...", treatedPs.getPathAsString()));
                        DocumentModel version = this.session.getSourceDocument(proxy.getRef());
                        if (version != null && version.isVersion()) {
                            version.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
                            version = this.resizePictureToThumbnail(version);
                            this.session.saveDocument(version);
                        } else {
                            log.warn((Object)String.format("PortalSite [%s] is in incoherent state: published but has no latest version", treatedPs.getPathAsString()));
                        }
                    }
                    this.session.save();
                }
                catch (Exception e) {
                    docsOnError.add(ps.getId());
                    throw new ClientException((Throwable)e);
                }
            }
        } else {
            log.info((Object)"======[Recovery mode]=====");
            for (DocumentModel ps : this.inputs) {
                try {
                    log.info((Object)String.format("Treating PS: [%s]", ps.getPathAsString()));
                    DocumentModel workingCopy = this.session.getWorkingCopy(ps.getRef());
                    workingCopy = this.resizePictureToThumbnail(workingCopy);
                    this.session.saveDocument(workingCopy);
                    DocumentModel version = this.session.getSourceDocument(ps.getRef());
                    if (version != null && version.isVersion()) {
                        version.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
                        version = this.resizePictureToThumbnail(version);
                        this.session.saveDocument(version);
                    } else {
                        log.warn((Object)String.format("PortalSite [%s] is in incoherent state: published but has no version", ps.getPathAsString()));
                    }
                    this.session.save();
                }
                catch (Exception e) {
                    docsOnError.add(ps.getId());
                    throw new ClientException((Throwable)e);
                }
            }
        }
    }

    protected DocumentModel resizePictureToThumbnail(DocumentModel ps) {
        DocumentModel res = null;
        OperationContext ctx = new OperationContext(this.session);
        ctx.setInput((Object)ps);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("img_heidth", 100);
        params.put("img_width", 100);
        params.put("xpath_img_in", "ttcn:picture");
        params.put("xpath_img_out", "ttc:vignette");
        params.put("enlarge", true);
        try {
            res = (DocumentModel)service.run(ctx, "ImageResize.Operation", params);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
        return res;
    }

    protected void setOnLine(DocumentModel treatedPs) {
        OperationContext ctx = new OperationContext(this.session);
        ctx.setInput((Object)treatedPs);
        HashMap params = new HashMap();
        try {
            service.run(ctx, "Document.SetOnLineOperation", params);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }
}

