/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.migration.runners;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.osivia.migration.runners.AbstractRunner;

public class RemoteProxiesRunner
extends AbstractRunner {
    private static Log log = LogFactory.getLog(RemoteProxiesRunner.class);
    private static final String REMOTE_ACRENNES_PROXIES_QUERIES = "select * from Document where ecm:isProxy = 1 and ecm:name like '%.remote.proxy%' and ecm:mixinType <> 'isRemoteProxy' and ecm:isVersion = 0 and ecm:currentLifeCycleState != 'deleted'";
    private static final String NO_LOCAL_PROXIES_QUERIES = "select * from Document where ecm:isProxy = 1 and ecm:name not like '%.proxy%' and ecm:mixinType <> 'isRemoteProxy' and ecm:isVersion = 0 and ecm:currentLifeCycleState != 'deleted'";

    public RemoteProxiesRunner(CoreSession session) {
        super(session);
    }

    @Override
    public int setInputs(int limit) {
        int size = 0;
        this.inputs = this.session.query(REMOTE_ACRENNES_PROXIES_QUERIES, limit);
        if (this.inputs.size() > 0) {
            size = this.inputs.size();
        } else {
            this.inputs = this.session.query(NO_LOCAL_PROXIES_QUERIES, limit);
            size = this.inputs.size();
        }
        this.totalInputs += size;
        return size;
    }

    @Override
    public void run() throws ClientException {
        for (DocumentModel remoteProxy : this.inputs) {
            if (remoteProxy.hasFacet("isRemoteProxy")) continue;
            remoteProxy.addFacet("isRemoteProxy");
            this.session.saveDocument(remoteProxy);
            ++this.treatedInputs;
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)(remoteProxy.getPathAsString() + " migrated"));
        }
        this.session.save();
    }
}

