/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.migration.transaction;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.RollbackException;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.transaction.TransactionHelper;
import org.nuxeo.runtime.transaction.TransactionRuntimeException;

public class LauncherTransactionHelper {
    private static final Log log = LogFactory.getLog(LauncherTransactionHelper.class);
    public static final String[] UT_NAMES = new String[]{"java:comp/UserTransaction", "java:comp/env/UserTransaction", "UserTransaction"};

    private LauncherTransactionHelper() {
    }

    public static UserTransaction lookupUserTransaction() throws NamingException {
        InitialContext context = new InitialContext();
        int i = 0;
        for (String name : UT_NAMES) {
            try {
                Object lookup = context.lookup(name);
                UserTransaction userTransaction = (UserTransaction)lookup;
                if (userTransaction != null) {
                    if (i != 0) {
                        LauncherTransactionHelper.UT_NAMES[i] = UT_NAMES[0];
                        LauncherTransactionHelper.UT_NAMES[0] = name;
                    }
                    return userTransaction;
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            ++i;
        }
        throw new NamingException("UserTransaction not found in JNDI");
    }

    public static void checkNStartTransaction() {
        if (!TransactionHelper.isTransactionActive()) {
            TransactionHelper.startTransaction();
        } else {
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
        }
    }

    public static boolean checkNStartTransactionWithStatus() {
        boolean tx;
        if (!TransactionHelper.isTransactionActive()) {
            tx = TransactionHelper.startTransaction();
        } else {
            TransactionHelper.commitOrRollbackTransaction();
            tx = TransactionHelper.startTransaction();
        }
        return tx;
    }

    public static void commitOrRollbackTransaction() {
        UserTransaction ut;
        try {
            ut = LauncherTransactionHelper.lookupUserTransaction();
        }
        catch (NamingException e) {
            log.warn((Object)"No user transaction", (Throwable)e);
            return;
        }
        try {
            int status = ut.getStatus();
            if (status == 0) {
                if (log.isDebugEnabled()) {
                    // empty if block
                }
                ut.commit();
            } else if (status == 1) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Cannot commit transaction because it is marked rollback only");
                }
                ut.rollback();
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Cannot commit transaction with unknown status: " + status));
            }
        }
        catch (Exception e) {
            String msg = "Unable to commit/rollback  " + ut;
            if (e instanceof RollbackException && "Unable to commit: transaction marked for rollback".equals(e.getMessage())) {
                log.debug((Object)msg, (Throwable)e);
            } else {
                log.error((Object)msg, (Throwable)e);
            }
            throw new TransactionRuntimeException(msg, (Throwable)e);
        }
    }

    public static boolean setTransactionRollbackOnly() {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Setting transaction as rollback only");
            }
            LauncherTransactionHelper.lookupUserTransaction().setRollbackOnly();
            return true;
        }
        catch (NamingException namingException) {
        }
        catch (Exception e) {
            log.error((Object)"Could not mark transaction as rollback only", (Throwable)e);
        }
        return false;
    }

    public static boolean rollbackTransaction() {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Rollback transaction");
            }
            LauncherTransactionHelper.lookupUserTransaction().rollback();
            return true;
        }
        catch (NamingException namingException) {
        }
        catch (Exception e) {
            log.error((Object)"Could not rollback transaction", (Throwable)e);
        }
        return false;
    }
}

