/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import fr.toutatice.ecm.platform.automation.FetchPublicationInfos;
import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;

@Operation(id="Fetch.PublishingStatusChildren", category="Fetch", label="Fetch live tree with publishing infos", description="Fetch children of document with publishing infos.")
public class FetchPublishingStatusChildren {
    private static final String DELETED_STATE = "deleted";
    public static final String ID = "Fetch.PublishingStatusChildren";
    private static final Log log = LogFactory.getLog(FetchPublishingStatusChildren.class);
    @Context
    protected CoreSession documentManager;
    @Param(name="documentId", required=true)
    protected DocumentModel document;
    @Param(name="publishStatus", required=true)
    protected String publishStatus;

    @OperationMethod
    public Object run() throws ClientException, FetchPublicationInfos.ServeurException, UnsupportedEncodingException {
        JSONArray childrenWithStatus = new JSONArray();
        if (this.document.isProxy()) {
            log.warn((Object)("Document " + this.document.getId() + " is proxy: can't access children."));
            return childrenWithStatus;
        }
        DocumentModelList children = this.documentManager.getChildren(this.document.getRef());
        for (DocumentModel child : children) {
            boolean isDeleted = DELETED_STATE.equals(child.getCurrentLifeCycleState());
            JSONObject childWithStatus = new JSONObject();
            if (PublishStatus.live.getStatus().equals(this.publishStatus) && !child.isProxy() && !isDeleted) {
                childrenWithStatus = this.getInfosFromLive(childrenWithStatus, child, childWithStatus);
                continue;
            }
            if (PublishStatus.published.getStatus().equals(this.publishStatus) && child.isProxy() && !isDeleted) {
                childrenWithStatus = this.getInfosFromPublished(childrenWithStatus, child, childWithStatus);
                continue;
            }
            if (!PublishStatus.liveNRemotePublished.getStatus().equals(this.publishStatus) || isDeleted) continue;
            if (!child.isProxy()) {
                childrenWithStatus = this.getInfosFromLive(childrenWithStatus, child, childWithStatus);
                continue;
            }
            if (!ToutaticeDocumentHelper.isRemoteProxy((DocumentModel)child)) continue;
            childrenWithStatus = this.getInfosFromPublished(childrenWithStatus, child, childWithStatus);
        }
        return new StringBlob(childrenWithStatus.toString(), "application/json");
    }

    private JSONArray getInfosFromPublished(JSONArray childrenWithStatus, DocumentModel child, JSONObject childWithStatus) throws UnsupportedEncodingException {
        childWithStatus.element("isPublished", true);
        DocumentModel srcDocument = this.documentManager.getSourceDocument(child.getRef());
        DocumentModel liveDocument = this.documentManager.getWorkingCopy(srcDocument.getRef());
        boolean isLiveModifiedFromProxy = !child.getVersionLabel().equals(liveDocument.getVersionLabel());
        childWithStatus.element("isLiveModifiedFromProxy", isLiveModifiedFromProxy);
        childrenWithStatus = this.fillGlobalProperties(childrenWithStatus, child, childWithStatus);
        return childrenWithStatus;
    }

    private JSONArray getInfosFromLive(JSONArray childrenWithStatus, DocumentModel child, JSONObject childWithStatus) throws UnsupportedEncodingException {
        String publishedChildVersionLabel = ToutaticeDocumentHelper.getProxyVersion((CoreSession)this.documentManager, (DocumentModel)child);
        boolean isPublished = publishedChildVersionLabel != null;
        childWithStatus.element("isPublished", isPublished);
        if (isPublished) {
            boolean isLiveModifiedFromProxy = !child.getVersionLabel().equals(publishedChildVersionLabel);
            childWithStatus.element("isLiveModifiedFromProxy", isLiveModifiedFromProxy);
        } else {
            childWithStatus.element("isLiveModifiedFromProxy", false);
        }
        childrenWithStatus = this.fillGlobalProperties(childrenWithStatus, child, childWithStatus);
        return childrenWithStatus;
    }

    public JSONArray fillGlobalProperties(JSONArray childrenWithStatus, DocumentModel child, JSONObject childWithStatus) throws ClientException, UnsupportedEncodingException {
        childWithStatus.element("docId", (Object)child.getId());
        childWithStatus.element("docPath", (Object)URLEncoder.encode(child.getPathAsString(), "UTF-8"));
        childWithStatus.element("docType", (Object)child.getType());
        childWithStatus.element("docTitle", (Object)URLEncoder.encode(child.getTitle(), "UTF-8"));
        boolean isFolderish = child.getFacets().contains("Folderish");
        childWithStatus.element("isFolderish", isFolderish);
        childrenWithStatus.add((Object)childWithStatus);
        return childrenWithStatus;
    }

    public static enum PublishStatus {
        live("1"),
        published(""),
        notLocalLives("2"),
        liveNRemotePublished("3");

        private String status;

        private PublishStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }
    }
}

