/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelIterator;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.elasticsearch.api.ElasticSearchIndexing;
import org.nuxeo.elasticsearch.commands.IndexingCommand;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Document.OrderDocument", category="Document", label="Order input Documents", description="Order the given documents in the given container. The orderd document will become the input of the next operation.Manage associated local proxies if any.")
public class OrderDocument {
    public static final String ID = "Document.OrderDocument";
    @Context
    protected CoreSession session;
    @Param(name="sourceId", required=true)
    protected DocumentModel source;
    @Param(name="targetId", required=false)
    protected String targetId = "";
    @Param(name="position", values={"before", "after"}, required=false)
    protected String position = "before";

    @OperationMethod
    public DocumentModel run() throws Exception {
        DocumentModel parentDocument = this.session.getParentDocument(this.source.getRef());
        if (this.session.hasPermission(parentDocument.getRef(), "AddChildren")) {
            DocumentModel target = this.getTargetDocument();
            String targetName = null;
            if (target != null) {
                targetName = target.getName();
            }
            if (StringUtils.equalsIgnoreCase((String)"before", (String)this.position)) {
                this.session.orderBefore(parentDocument.getRef(), this.source.getName(), targetName);
                this.orderProxyBefore(parentDocument, targetName);
            } else if (StringUtils.equalsIgnoreCase((String)"after", (String)this.position)) {
                this.session.orderBefore(parentDocument.getRef(), targetName, this.source.getName());
                this.orderProxyAfter(parentDocument, targetName);
            }
            this.indexReorderedChildren(parentDocument);
        }
        return this.source;
    }

    public void indexReorderedChildren(DocumentModel parentDocument) {
        Filter filter = new Filter(){
            private static final long serialVersionUID = 6829091503899474742L;

            public boolean accept(DocumentModel docModel) {
                boolean notTrashed = !StringUtils.equals((String)"deleted", (String)docModel.getCurrentLifeCycleState());
                return !docModel.isVersion() && notTrashed;
            }
        };
        DocumentModelIterator childrenIterator = this.session.getChildrenIterator(parentDocument.getRef(), null, null, filter);
        if (childrenIterator != null) {
            ArrayList<IndexingCommand> cmds = new ArrayList<IndexingCommand>(2);
            while (childrenIterator.hasNext()) {
                cmds.add(new IndexingCommand((DocumentModel)childrenIterator.next(), IndexingCommand.Type.UPDATE, true, false));
            }
            ElasticSearchIndexing esi = (ElasticSearchIndexing)Framework.getService(ElasticSearchIndexing.class);
            esi.indexNonRecursive(cmds);
        }
    }

    private DocumentModel getTargetDocument() {
        DocumentModel target = null;
        if (StringUtils.isNotBlank((String)this.targetId)) {
            try {
                target = this.session.getDocument((DocumentRef)new IdRef(this.targetId));
            }
            catch (Exception ie) {
                try {
                    target = this.session.getDocument((DocumentRef)new PathRef(this.targetId));
                }
                catch (Exception pe) {
                    target = null;
                }
            }
        }
        return target;
    }

    private void orderProxyBefore(DocumentModel parentDocument, String targetName) {
        DocumentModelList localProxies = this.session.getProxies(this.source.getRef(), parentDocument.getRef());
        if (CollectionUtils.isNotEmpty((Collection)localProxies)) {
            for (DocumentModel proxy : localProxies) {
                this.session.orderBefore(parentDocument.getRef(), proxy.getName(), targetName);
            }
        }
    }

    private void orderProxyAfter(DocumentModel parentDocument, String targetName) {
        DocumentModelList localProxies = this.session.getProxies(this.source.getRef(), parentDocument.getRef());
        if (CollectionUtils.isNotEmpty((Collection)localProxies)) {
            for (DocumentModel proxy : localProxies) {
                this.session.orderBefore(parentDocument.getRef(), targetName, proxy.getName());
            }
        }
    }
}

