/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation.document.transaction.test;

import java.util.Map;
import java.util.concurrent.Callable;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.jtajca.NuxeoContainer;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class ConversationThread
implements Callable<Object> {
    private static final Log log = LogFactory.getLog(ConversationThread.class);
    private Transaction tx;
    private CoreSession session;
    private TransactionManager tm = NuxeoContainer.getTransactionManager();
    private AutomationService srv = (AutomationService)Framework.getService(AutomationService.class);
    private String userName;
    private String opId;
    private OperationContext callingCtx;
    private Map<String, Object> params;
    public Object result;

    public ConversationThread(OperationContext callingCtx, String opId, Map<String, Object> parameters, String userName) {
        this.userName = userName;
        this.opId = opId;
        this.callingCtx = callingCtx;
        this.params = parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() throws Exception {
        log.error((Object)("New thread: " + Thread.currentThread()));
        try {
            TransactionHelper.startTransaction();
            if (this.session == null) {
                this.session = CoreInstance.openCoreSession(null, (String)this.userName);
            }
            OperationContext ctx = new OperationContext(this.session);
            ctx.setInput(this.callingCtx.getInput());
            ctx.setCommit(false);
            this.result = this.srv.run(ctx, this.opId, this.params);
            if (this.result instanceof DocumentModel) {
                ((DocumentModel)this.result).isCheckedOut();
                ((DocumentModel)this.result).getLockInfo();
                for (String schema : ((DocumentModel)this.result).getSchemas()) {
                    ((DocumentModel)this.result).getPart(schema);
                }
            }
            if (this.result instanceof DocumentModelList) {
                for (DocumentModel doc : (DocumentModelList)this.result) {
                    doc.isCheckedOut();
                    doc.getLockInfo();
                }
            }
            Thread.sleep(100000L);
            this.session.save();
        }
        catch (Exception e) {
            TransactionHelper.setTransactionRollbackOnly();
            log.error((Object)e);
        }
        finally {
            if (this.session != null) {
                this.session.close();
            }
            TransactionHelper.commitOrRollbackTransaction();
        }
        return this.result;
    }
}

