/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation.document.transaction.test;

import fr.toutatice.ecm.platform.automation.document.transaction.test.ConversationThread;
import java.security.Principal;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;

@Operation(id="FetchLiveDocumentInTransaction")
public class FetchLiveDocumentInTransaction {
    private static final Log log = LogFactory.getLog(FetchLiveDocumentInTransaction.class);
    private static final String AND = "AND";
    private static final String OR = "OR";
    @Context
    protected OperationContext ctx;
    @Context
    protected CoreSession session;
    @Param(name="value", required=true)
    protected DocumentModel value;
    @Param(name="permission", required=false, values={"Read", "ReadWrite", "Write"})
    protected String permission = "Write";
    @Param(name="operation", required=false, values={"OR", "AND"})
    protected String operation = "OR";

    @OperationMethod
    public Object run() throws Exception {
        log.error((Object)("Incoming thread: " + Thread.currentThread()));
        Principal principal = this.session.getPrincipal();
        String userName = principal != null ? principal.getName() : "";
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("value", this.value);
        ConversationThread conversation = new ConversationThread(this.ctx, "Document.FetchLiveDocument", params, userName);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.submit(conversation);
        while (conversation.result == null) {
            Thread.sleep(1000L);
        }
        return (DocumentModel)conversation.result;
    }
}

