/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation.transaction.filter;

import fr.toutatice.ecm.platform.automation.transaction.component.ToutaticeAutomationServiceHandler;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransactionalConversationFilter
implements Filter {
    private static final Log log = LogFactory.getLog(TransactionalConversationFilter.class);
    public static final String TX_CONVERSATION_ID = "Tx-conversation-id";
    private static final String NOTIFY_TX_MANAGER_OP_ID = "Conversation.NotifyManager";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpReq = (HttpServletRequest)request;
        String txId = httpReq.getHeader(TX_CONVERSATION_ID);
        if (StringUtils.isNotBlank((String)txId)) {
            String opId = this.getCallingOperationId(httpReq);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Calling operation: " + opId + " in " + txId + " transaction"));
            }
            if (!StringUtils.equals((String)NOTIFY_TX_MANAGER_OP_ID, (String)opId)) {
                ToutaticeAutomationServiceHandler.threadLocal.set(txId);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Not forwaded");
            }
        }
        try {
            chain.doFilter(request, response);
        }
        finally {
            ToutaticeAutomationServiceHandler.threadLocal.remove();
        }
    }

    private String getCallingOperationId(HttpServletRequest httpReq) {
        return StringUtils.substringAfterLast((String)httpReq.getPathInfo(), (String)"/");
    }

    public void destroy() {
    }
}

