/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk;

import com.sun.jdmk.ModifiableClassLoaderRepository;
import com.sun.jdmk.internal.ClassLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.ObjectName;
import javax.management.loading.PrivateClassLoader;

public final class ClassLoaderRepositorySupport
implements ModifiableClassLoaderRepository {
    private static final LoaderEntry[] EMPTY_LOADER_ARRAY = new LoaderEntry[0];
    private LoaderEntry[] loaders = EMPTY_LOADER_ARRAY;
    private final Hashtable search = new Hashtable(10);
    private final Hashtable loadersWithNames = new Hashtable(10);
    private static final String dbgTag = "ClassLoaderRepositorySupport";
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.mbeanserver", "ClassLoaderRepositorySupport");

    private synchronized boolean add(ObjectName name, ClassLoader cl) {
        ArrayList<LoaderEntry> l = new ArrayList<LoaderEntry>(Arrays.asList(this.loaders));
        l.add(new LoaderEntry(name, cl));
        this.loaders = l.toArray(EMPTY_LOADER_ARRAY);
        return true;
    }

    private synchronized boolean remove(ObjectName name, ClassLoader cl) {
        int size = this.loaders.length;
        int i = 0;
        while (i < size) {
            boolean match;
            LoaderEntry entry = this.loaders[i];
            boolean bl = name == null ? cl == entry.loader : (match = name.equals(entry.name));
            if (match) {
                LoaderEntry[] newloaders = new LoaderEntry[size - 1];
                System.arraycopy(this.loaders, 0, newloaders, 0, i);
                System.arraycopy(this.loaders, i + 1, newloaders, i, size - 1 - i);
                this.loaders = newloaders;
                return true;
            }
            ++i;
        }
        return false;
    }

    public final Class loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(this.loaders, className, null, null);
    }

    public final Class loadClassWithout(ClassLoader without, String className) throws ClassNotFoundException {
        if (logger.finerOn()) {
            logger.finer("loadClassWithout", String.valueOf(className) + "\twithout " + without);
        }
        if (without == null) {
            return this.loadClass(this.loaders, className, null, null);
        }
        this.startValidSearch(without, className);
        try {
            Class clazz = this.loadClass(this.loaders, className, without, null);
            return clazz;
        }
        finally {
            this.stopValidSearch(without, className);
        }
    }

    public final Class loadClassBefore(ClassLoader stop, String className) throws ClassNotFoundException {
        if (logger.finerOn()) {
            logger.finer("loadClassBefore", String.valueOf(className) + "\tbefore " + stop);
        }
        if (stop == null) {
            return this.loadClass(this.loaders, className, null, null);
        }
        this.startValidSearch(stop, className);
        try {
            Class clazz = this.loadClass(this.loaders, className, null, stop);
            return clazz;
        }
        finally {
            this.stopValidSearch(stop, className);
        }
    }

    private Class loadClass(LoaderEntry[] list, String className, ClassLoader without, ClassLoader stop) throws ClassNotFoundException {
        int size = list.length;
        int i = 0;
        while (i < size) {
            try {
                ClassLoader cl = list[i].loader;
                if (cl == null) {
                    return Class.forName(className, false, null);
                }
                if (cl != without) {
                    if (cl == stop) break;
                    if (logger.finerOn()) {
                        logger.finer("loadClass", "trying loader = " + cl);
                    }
                    return Class.forName(className, false, cl);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            ++i;
        }
        throw new ClassNotFoundException(className);
    }

    private synchronized void startValidSearch(ClassLoader aloader, String className) throws ClassNotFoundException {
        Vector<ClassLoader> excluded = (Vector<ClassLoader>)this.search.get(className);
        if (excluded != null && excluded.contains(aloader)) {
            if (logger.finerOn()) {
                logger.finer("startValidSearch", "already requested loader=" + aloader + " class= " + className);
            }
            throw new ClassNotFoundException(className);
        }
        if (excluded == null) {
            excluded = new Vector<ClassLoader>(1);
            this.search.put(className, excluded);
        }
        excluded.addElement(aloader);
        if (logger.finerOn()) {
            logger.finer("startValidSearch", "loader=" + aloader + " class= " + className);
        }
    }

    private synchronized void stopValidSearch(ClassLoader aloader, String className) {
        Vector excluded = (Vector)this.search.get(className);
        if (excluded != null) {
            excluded.removeElement(aloader);
            if (logger.finerOn()) {
                logger.finer("stopValidSearch", "loader=" + aloader + " class= " + className);
            }
        }
    }

    @Override
    public final void addClassLoader(ClassLoader loader) {
        this.add(null, loader);
    }

    @Override
    public final void removeClassLoader(ClassLoader loader) {
        this.remove(null, loader);
    }

    @Override
    public final synchronized void addClassLoader(ObjectName name, ClassLoader loader) {
        this.loadersWithNames.put(name, loader);
        if (!(loader instanceof PrivateClassLoader)) {
            this.add(name, loader);
        }
    }

    @Override
    public final synchronized void removeClassLoader(ObjectName name) {
        ClassLoader loader = (ClassLoader)this.loadersWithNames.remove(name);
        if (!(loader instanceof PrivateClassLoader)) {
            this.remove(name, loader);
        }
    }

    @Override
    public final ClassLoader getClassLoader(ObjectName name) {
        return (ClassLoader)this.loadersWithNames.get(name);
    }

    private static class LoaderEntry {
        ObjectName name;
        ClassLoader loader;

        LoaderEntry(ObjectName name, ClassLoader loader) {
            this.name = name;
            this.loader = loader;
        }
    }
}

