/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.core.helper;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.rendering.api.ResourceLocator;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.resource.ResourceService;

public class AcarenResourceLocatorHelper
implements ResourceLocator {
    private static final Log log = LogFactory.getLog(AcarenResourceLocatorHelper.class);
    private ResourceService service = null;
    private static AcarenResourceLocatorHelper instance;

    private AcarenResourceLocatorHelper() {
    }

    public static AcarenResourceLocatorHelper instance() {
        if (null == instance) {
            instance = new AcarenResourceLocatorHelper();
        }
        return instance;
    }

    public URL getResourceURL(String key) {
        URL url = null;
        ResourceService rs = this.getService();
        if (null != rs) {
            url = rs.getResource(key);
        }
        return url;
    }

    public File getResourceFile(String key) {
        URL url = this.getResourceURL(key);
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            log.error((Object)("Failed to get the file from key '" + key + "', error: " + e.getMessage()));
            return null;
        }
    }

    private ResourceService getService() {
        if (null == this.service) {
            try {
                return (ResourceService)Framework.getService(ResourceService.class);
            }
            catch (Exception e) {
                log.error((Object)("Failed to get the resource service, error: " + e.getMessage()));
            }
        }
        return this.service;
    }
}

