/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.core.helper;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.features.PrincipalHelper;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.PermissionProvider;
import org.nuxeo.ecm.platform.usermanager.UserManager;

public class AcarenUserManagerHelper
extends PrincipalHelper {
    public AcarenUserManagerHelper(UserManager userManager, PermissionProvider permissionProvider) {
        super(userManager, permissionProvider);
    }

    public Set<String> getEmailsForPermission(DocumentModel input, String permission, boolean ignoreGroups, boolean strict) throws ClientException {
        EmailCollector collector = new EmailCollector(this.userManager.getUserSchemaName(), this.userManager.getUserEmailField());
        return this.collectEmailsMatchingPermission(input, permission, ignoreGroups, true, collector, strict);
    }

    public HashSet<?> collectEmailsMatchingPermission(DocumentModel input, String permission, boolean ignoreGroups, boolean resolveGroups, Collector<?> collector, boolean strict) throws ClientException {
        String[] perms = strict ? new String[]{permission} : this.getPermissionsToCheck(permission);
        ACP acp = input.getACP();
        for (ACL acl : acp.getACLs()) {
            for (ACE ace : acl.getACEs()) {
                if (!ace.isGranted() || !this.permissionMatch(perms, ace.getPermission())) continue;
                NuxeoGroup group = this.userManager.getGroup(ace.getUsername());
                if (group == null) {
                    collector.collect(this.userManager.getPrincipal(ace.getUsername()));
                    continue;
                }
                if (ignoreGroups) continue;
                if (resolveGroups) {
                    this.resolveGroups(group, collector);
                    continue;
                }
                collector.collect(group);
            }
        }
        return collector.getResult();
    }

    public void resolveGroups(NuxeoGroup group, Collector<?> collector) throws ClientException {
        if (group != null) {
            for (String memberUser : group.getMemberUsers()) {
                collector.collect(this.userManager.getPrincipal(memberUser));
            }
            for (String subGroup : group.getMemberGroups()) {
                this.resolveGroups(this.userManager.getGroup(subGroup), collector);
            }
        }
    }

    public static interface Collector<T> {
        public void collect(NuxeoPrincipal var1) throws ClientException;

        public void collect(NuxeoGroup var1) throws ClientException;

        public HashSet<T> getResult();
    }

    protected static class EmailCollector
    implements Collector<String> {
        protected final String userSchemaName;
        protected final String userEmailFieldName;
        protected HashSet<String> result = new HashSet();

        protected EmailCollector(String userSchemaName, String userEmailFieldName) {
            this.userSchemaName = userSchemaName;
            this.userEmailFieldName = userEmailFieldName;
        }

        @Override
        public void collect(NuxeoPrincipal principal) throws ClientException {
            if (principal == null) {
                return;
            }
            DocumentModel userEntry = principal.getModel();
            String email = (String)userEntry.getProperty(this.userSchemaName, this.userEmailFieldName);
            if (!StringUtils.isEmpty((String)email)) {
                this.result.add(email);
            }
        }

        @Override
        public void collect(NuxeoGroup group) throws ClientException {
        }

        @Override
        public HashSet<String> getResult() {
            return this.result;
        }
    }
}

