/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.core.listener;

import fr.toutatice.ecm.platform.core.helper.ToutaticeUserMngtHelper;
import java.io.Serializable;
import java.security.Principal;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.platform.dublincore.NXDublinCore;
import org.nuxeo.ecm.platform.dublincore.service.DublinCoreStorageService;
import org.nuxeo.runtime.api.Framework;

public class AcrennesEventListner
implements EventListener {
    private static final Log log = LogFactory.getLog(AcrennesEventListner.class);

    public void handleEvent(Event event) throws ClientException {
        if (event.getContext() instanceof DocumentEventContext) {
            DocumentModel doc;
            String eventName;
            block19: {
                Principal principal;
                DocumentEventContext eventContext = (DocumentEventContext)event.getContext();
                eventName = event.getName();
                doc = eventContext.getSourceDocument();
                if ("emptyDocumentModelCreated".equals(eventName) && null != (principal = eventContext.getPrincipal())) {
                    SchemaManager schemaMgr;
                    DocumentModel parent;
                    CoreSession session;
                    String parentPath;
                    String principalName = principal.getName();
                    if (doc.hasSchema("acaren")) {
                        doc.setPropertyValue("acr:auteur", (Serializable)((Object)principalName));
                    }
                    if (doc.hasSchema("demande")) {
                        doc.setPropertyValue("dde:demandeur", (Serializable)((Object)ToutaticeUserMngtHelper.instance().getCurrentUserFullName(principalName)));
                    }
                    if ("ContactMessage".equals(doc.getType())) {
                        parentPath = (String)((Object)eventContext.getProperty("parentPath"));
                        session = eventContext.getCoreSession();
                        parent = session.getDocument((DocumentRef)new PathRef(parentPath));
                        String[] dests = (String[])parent.getPropertyValue("cmf:recipients");
                        if (null != dests && 0 < dests.length) {
                            doc.setPropertyValue("mail:recipients", (Serializable)dests);
                        }
                    }
                    if ("Annonce".equals(doc.getType())) {
                        parentPath = (String)((Object)eventContext.getProperty("parentPath"));
                        session = eventContext.getCoreSession();
                        parent = session.getDocument((DocumentRef)new PathRef(parentPath));
                        String[] keywords = (String[])parent.getPropertyValue("dc:subjects");
                        if (keywords != null && keywords.length > 0) {
                            doc.setPropertyValue("dc:subjects", (Serializable)keywords);
                        }
                    }
                    if ((schemaMgr = (SchemaManager)Framework.getLocalService(SchemaManager.class)).getSchema("webcontainer").getField("email") != null && doc.hasSchema("webcontainer")) {
                        try {
                            String userEmail = ToutaticeUserMngtHelper.instance().getUserProperty(principalName, "user:email");
                            if (StringUtils.isNotBlank((String)userEmail)) {
                                doc.setPropertyValue("webc:email", (Serializable)((Object)userEmail));
                            }
                        }
                        catch (Exception e) {
                            if (!log.isErrorEnabled()) break block19;
                            log.error((Object)("Failed to get the service 'UserManager', error: " + e.getMessage()));
                            throw new ClientException((Throwable)e);
                        }
                    }
                }
            }
            if ("beforeDocumentModification".equals(eventName) || "aboutToCreate".equals(eventName)) {
                if (doc.isImmutable()) {
                    return;
                }
                SchemaManager schemaMgr = (SchemaManager)Framework.getLocalService(SchemaManager.class);
                if (doc.hasSchema("acaren") && schemaMgr.getSchema("dublincore").getField("creator") != null) {
                    String author = (String)((Object)doc.getPropertyValue("acr:auteur"));
                    if (StringUtils.isNotBlank((String)author)) {
                        if ("aboutToCreate".equals(eventName)) {
                            DublinCoreStorageService DCSService = NXDublinCore.getDublinCoreStorageService();
                            DCSService.addContributor(doc, event);
                        }
                        doc.setPropertyValue("dc:creator", (Serializable)((Object)author));
                    } else {
                        String creator = (String)((Object)doc.getPropertyValue("dc:creator"));
                        if (StringUtils.isNotBlank((String)creator)) {
                            doc.setPropertyValue("acr:auteur", (Serializable)((Object)creator));
                        }
                    }
                }
            }
        }
    }
}

