/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.core.listener;

import java.util.HashMap;
import org.apache.commons.lang.ArrayUtils;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.runtime.api.Framework;

public class AcrennesPictureToThumbnail
implements EventListener {
    private static final String[] DOC_TYPES = new String[]{"PortalSite"};
    private static final String PICTURE_XPATH_PROP = "ttcn:picture";
    private static final String THUMBNAIL_XPATH_PROP = "ttc:vignette";
    private static final String IMAGE_RESIZE_OPERATION = "ImageResize.Operation";
    private static final AutomationService service = (AutomationService)Framework.getService(AutomationService.class);

    public void handleEvent(Event event) throws ClientException {
        Property picture;
        DocumentEventContext eventContext;
        DocumentModel srcDoc;
        if (("aboutToCreate".equals(event.getName()) || "beforeDocumentModification".equals(event.getName())) && event.getContext() instanceof DocumentEventContext && ArrayUtils.contains((Object[])DOC_TYPES, (Object)(srcDoc = (eventContext = (DocumentEventContext)event.getContext()).getSourceDocument()).getType()) && (picture = srcDoc.getProperty(PICTURE_XPATH_PROP)) != null && picture.isDirty()) {
            CoreSession session = eventContext.getCoreSession();
            this.resizePictureToThumbnail(session, srcDoc);
        }
    }

    protected DocumentModel resizePictureToThumbnail(CoreSession session, DocumentModel doc) {
        DocumentModel res = null;
        OperationContext ctx = new OperationContext(session);
        ctx.setInput((Object)doc);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("img_heidth", 100);
        params.put("img_width", 100);
        params.put("xpath_img_in", PICTURE_XPATH_PROP);
        params.put("xpath_img_out", THUMBNAIL_XPATH_PROP);
        params.put("enlarge", true);
        try {
            res = (DocumentModel)service.run(ctx, IMAGE_RESIZE_OPERATION, params);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
        return res;
    }
}

