/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.core.listener;

import fr.toutatice.ecm.acrennes.core.filter.AcrennesPFParentFilter;
import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import java.io.Serializable;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class AcrennesPreSetMetaData
implements EventListener {
    public void handleEvent(Event event) throws ClientException {
        if (event.getContext() instanceof DocumentEventContext) {
            DocumentEventContext eventContext = (DocumentEventContext)event.getContext();
            DocumentModel document = eventContext.getSourceDocument();
            String parentPath = (String)((Object)eventContext.getProperty("parentPath"));
            if (null == parentPath || document.isProxy() || ToutaticeDocumentHelper.isRuntimeDocument((DocumentModel)document)) {
                return;
            }
            InnerPreSetMetaData runner = new InnerPreSetMetaData(eventContext.getCoreSession(), document, parentPath);
            runner.runUnrestricted();
        }
    }

    private class InnerPreSetMetaData
    extends UnrestrictedSessionRunner {
        DocumentModel doc;
        String parentPath;

        public InnerPreSetMetaData(CoreSession session, DocumentModel doc, String parentPath) {
            super(session);
            this.doc = doc;
            this.parentPath = parentPath;
        }

        public void run() throws ClientException {
            DocumentModelList pList;
            String type;
            DocumentModel parent;
            DocumentModel domain;
            if ((this.doc.hasSchema("tic") || this.doc.hasSchema("pilotage")) && null != (domain = ToutaticeDocumentHelper.getDomain((CoreSession)this.session, (DocumentModel)(parent = this.session.getDocument((DocumentRef)new PathRef(this.parentPath))), (boolean)true)) && "pf".equals(type = (String)((Object)domain.getPropertyValue("acaren:commutateur"))) && null != (pList = ToutaticeDocumentHelper.getParentList((CoreSession)this.session, (DocumentModel)parent, (Filter)new AcrennesPFParentFilter(), (boolean)true, (boolean)true, (boolean)true)) && !pList.isEmpty()) {
                Serializable pv;
                parent = (DocumentModel)pList.get(0);
                if (this.doc.hasSchema("tic")) {
                    pv = parent.getPropertyValue("tic:academie");
                    this.doc.setPropertyValue("tic:academie", pv);
                    pv = parent.getPropertyValue("tic:categoriePf");
                    this.doc.setPropertyValue("tic:categoriePf", pv);
                }
                if (this.doc.hasSchema("pilotage")) {
                    pv = parent.getPropertyValue("pilotage:anneeScolaire");
                    this.doc.setPropertyValue("pilotage:anneeScolaire", pv);
                }
            }
        }
    }
}

