/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.acrennes.core.security;

import java.security.Principal;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.Access;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.security.AbstractSecurityPolicy;
import org.nuxeo.runtime.api.Framework;

public class PreventRemoveDefaultContentPolicy
extends AbstractSecurityPolicy {
    private static final Log log = LogFactory.getLog((String)"PreventRemoveDefaultContentPolicy");
    private String creator = Framework.getProperty((String)"acrennes.espacesecole.creator", (String)"adminespaceecole");

    public Access checkPermission(Document doc, ACP mergedAcp, Principal principal, String permission, String[] resolvedPermissions, String[] additionalPrincipals) {
        if (permission.equals("Remove")) {
            try {
                String docCreator = (String)((Object)doc.getPropertyValue("dc:creator"));
                if (StringUtils.equalsIgnoreCase((String)this.creator, (String)docCreator)) {
                    return Access.DENY;
                }
            }
            catch (DocumentException documentException) {
                // empty catch block
            }
        }
        return Access.UNKNOWN;
    }

    public boolean isExpressibleInQuery() {
        return true;
    }

    public SQLQuery.Transformer getQueryTransformer() {
        return SQLQuery.Transformer.IDENTITY;
    }
}

