/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.international;

import java.util.Date;
import java.util.TimeZone;

public class TimeZoneWrapper
extends TimeZone {
    private static final int MILLISECONDS_PER_HOUR = 3600000;
    private TimeZone timeZone;

    public TimeZoneWrapper(TimeZone tz) {
        this.timeZone = tz;
        this.setID(tz.getID());
    }

    @Override
    public void setID(String id) {
        super.setID(id);
        this.timeZone = TimeZone.getTimeZone(id);
    }

    public String getId() {
        return this.timeZone.getID();
    }

    public String getLabel() {
        StringBuilder label = new StringBuilder(50);
        label.append(this.getId().replace("_", " "));
        label.append(" (UTC");
        label.append(this.timeZone.getRawOffset() > 0 ? "+" : "-");
        if (Math.abs(this.timeZone.getRawOffset()) < 36000000) {
            label.append("0");
        }
        label.append(Math.abs(this.timeZone.getRawOffset()) / 3600000);
        label.append(":00)");
        return label.toString();
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public int getOffset(int era, int year, int month, int day, int dayOfWeek, int millis) {
        return this.timeZone.getOffset(era, year, month, day, dayOfWeek, millis);
    }

    @Override
    public void setRawOffset(int offset) {
        this.timeZone.setRawOffset(offset);
    }

    @Override
    public int getRawOffset() {
        return this.timeZone.getRawOffset();
    }

    @Override
    public boolean useDaylightTime() {
        return this.timeZone.useDaylightTime();
    }

    @Override
    public boolean inDaylightTime(Date date) {
        return this.timeZone.inDaylightTime(date);
    }

    @Override
    public Object clone() {
        return this.timeZone.clone();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeZoneWrapper other = (TimeZoneWrapper)obj;
        return this.timeZone == other.timeZone || this.timeZone != null && this.timeZone.equals(other.timeZone);
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (this.timeZone != null ? this.timeZone.hashCode() : 0);
        return hash;
    }
}

