/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security;

import java.io.IOException;
import java.io.Serializable;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.Events;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

@Name(value="org.jboss.seam.security.credentials")
@Scope(value=ScopeType.SESSION)
@Install(precedence=0)
@BypassInterceptors
public class Credentials
implements Serializable {
    public static final String EVENT_INIT_CREDENTIALS = "org.jboss.seam.security.initCredentials";
    public static final String EVENT_CREDENTIALS_UPDATED = "org.jboss.seam.security.credentialsUpdated";
    private static final LogProvider log = Logging.getLogProvider(Credentials.class);
    private String username;
    private String password;
    private boolean invalid = false;
    private boolean initialized;

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public String getUsername() {
        if (!this.isInitialized() && Events.exists()) {
            this.setInitialized(true);
            Events.instance().raiseEvent(EVENT_INIT_CREDENTIALS, this);
        }
        return this.username;
    }

    public void setUsername(String username) {
        if (!(this.username == username || this.username != null && this.username.equals(username))) {
            this.username = username;
            this.invalid = false;
            if (Events.exists()) {
                Events.instance().raiseEvent(EVENT_CREDENTIALS_UPDATED, new Object[0]);
            }
        }
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        if (!(this.password == password || this.password != null && this.password.equals(password))) {
            this.password = password;
            this.invalid = false;
            if (Events.exists()) {
                Events.instance().raiseEvent(EVENT_CREDENTIALS_UPDATED, new Object[0]);
            }
        }
    }

    public boolean isSet() {
        return this.getUsername() != null && this.password != null;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public void invalidate() {
        this.invalid = true;
    }

    public void clear() {
        this.username = null;
        this.password = null;
    }

    public CallbackHandler createCallbackHandler() {
        return new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (int i = 0; i < callbacks.length; ++i) {
                    if (callbacks[i] instanceof NameCallback) {
                        ((NameCallback)callbacks[i]).setName(Credentials.this.getUsername());
                        continue;
                    }
                    if (callbacks[i] instanceof PasswordCallback) {
                        ((PasswordCallback)callbacks[i]).setPassword(Credentials.this.getPassword() != null ? Credentials.this.getPassword().toCharArray() : null);
                        continue;
                    }
                    log.warn("Unsupported callback " + callbacks[i]);
                }
            }
        };
    }
}

