/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.es.customizer.nx.listener;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class TitleModificationListener
implements EventListener {
    public static final String DOC_CONTEXT_TITLE_MODIFICATION = "titleModification";
    private Log log = LogFactory.getLog(TitleModificationListener.class);

    public void handleEvent(Event event) throws ClientException {
        DocumentEventContext context = (DocumentEventContext)event.getContext();
        DocumentModel sourceDocument = context.getSourceDocument();
        if (sourceDocument != null && sourceDocument.hasFacet("Space") && this.isRootSpace(sourceDocument)) {
            boolean titleModification = true;
            List<String> lastDirtyFields = this.getDirtyPropertiesXPath(sourceDocument);
            for (String xpath : lastDirtyFields) {
                if (!xpath.equals("dublincore:title")) continue;
                titleModification = true;
            }
            if (titleModification) {
                context.getProperties().put(DOC_CONTEXT_TITLE_MODIFICATION, Boolean.TRUE);
                this.log.debug((Object)("Title has changed " + sourceDocument.getTitle()));
            }
        }
    }

    private List<String> getDirtyPropertiesXPath(DocumentModel doc) throws ClientException {
        DocumentPart[] docParts;
        ArrayList<String> dirtyPropertiesName = new ArrayList<String>();
        for (DocumentPart docPart : docParts = doc.getParts()) {
            Iterator dirtyChildrenIterator = docPart.getDirtyChildren();
            while (dirtyChildrenIterator.hasNext()) {
                Property property = (Property)dirtyChildrenIterator.next();
                if (!property.isContainer() && property.isDirty()) {
                    dirtyPropertiesName.add(docPart.getName() + ":" + property.getField().getName().getLocalName());
                    continue;
                }
                List<Property> dirtyProps = this.addChildrenDirtyProperties(property, new ArrayList<Property>());
                for (Property dirtyProperty : dirtyProps) {
                    dirtyPropertiesName.add(docPart.getName() + ":" + dirtyProperty.getPath().substring(1));
                }
            }
        }
        return dirtyPropertiesName;
    }

    private List<Property> addChildrenDirtyProperties(Property property, List<Property> dirtyProperties) {
        if (!property.isContainer() && property.isDirty()) {
            dirtyProperties.add(property);
            return dirtyProperties;
        }
        Iterator dirtyChildrenIterator = property.getDirtyChildren();
        while (dirtyChildrenIterator.hasNext()) {
            Property chilProperty = (Property)dirtyChildrenIterator.next();
            dirtyProperties = this.addChildrenDirtyProperties(chilProperty, dirtyProperties);
        }
        return dirtyProperties;
    }

    private boolean isRootSpace(DocumentModel sourceDocument) {
        CoreSession session = sourceDocument.getCoreSession();
        List parentDocuments = session.getParentDocuments(sourceDocument.getRef());
        DocumentModel rootSpace = null;
        for (DocumentModel element : parentDocuments) {
            if (!element.hasFacet("Space") || element.getType().equals("Domain")) continue;
            rootSpace = element;
            break;
        }
        return rootSpace.getId().equals(sourceDocument.getId());
    }
}

