/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.event;

import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import org.apache.directory.server.core.event.Evaluator;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.ScopeNode;
import org.apache.directory.shared.ldap.name.LdapDN;

public class ScopeEvaluator
implements Evaluator {
    public boolean evaluate(ExprNode node, String dn, Attributes record) throws NamingException {
        ScopeNode snode = (ScopeNode)node;
        switch (snode.getScope()) {
            case 0: {
                return dn.equals(snode.getBaseDn());
            }
            case 1: {
                if (dn.endsWith(snode.getBaseDn())) {
                    LdapDN candidateDn = new LdapDN(dn);
                    LdapDN scopeDn = new LdapDN(snode.getBaseDn());
                    return scopeDn.size() + 1 == candidateDn.size();
                }
            }
            case 2: {
                return dn.endsWith(snode.getBaseDn());
            }
        }
        throw new NamingException("Unrecognized search scope!");
    }
}

